/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.base;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.gui.base.Base;
import team.teampotato.ruok.gui.base.BaseUtil;
import team.teampotato.ruok.gui.base.RuOKGameOptions;
import team.teampotato.ruok.gui.base.content.DataContent;
import team.teampotato.ruok.gui.base.enumText.CompatibilityLevel;
import team.teampotato.ruok.gui.base.enumText.OptimizeLevel;
import team.teampotato.ruok.gui.base.enumText.PerformanceLevel;

public class BaseBuilder<T, V> {
    private final Base<V, T> base = new Base();
    private final Class<T> typeClass;

    private BaseBuilder(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public static <T> StepKey<T, RuOKGameOptions> create(Class<T> typeClass) {
        return new BuilderSteps(typeClass);
    }

    private static class BuilderSteps<T, V>
    implements StepKey<T, V>,
    StepGroup<T, V>,
    StepSetter<T, V>,
    StepGetter<T, V>,
    OptionalSteps<T, V> {
        private final BaseBuilder<T, V> builder;

        private BuilderSteps(Class<T> typeClass) {
            this.builder = new BaseBuilder(typeClass);
        }

        @Override
        public StepGroup<T, V> key(String key) {
            this.builder.base.key = key;
            return this;
        }

        @Override
        public StepSetter<T, V> group(BaseUtil.Group group) {
            this.builder.base.group = group;
            return this;
        }

        @Override
        public StepGetter<T, V> setter(BiConsumer<V, T> setter) {
            this.builder.base.biConsumer = setter;
            return this;
        }

        @Override
        public OptionalSteps<T, V> getter(Function<V, T> getter) {
            this.builder.base.function = getter;
            return this;
        }

        @Override
        public OptionalSteps<T, V> compatLevel(CompatibilityLevel compatibilityLevel) {
            this.builder.base.compatibilityLevel = compatibilityLevel;
            return this;
        }

        @Override
        public OptionalSteps<T, V> optimizeLevel(OptimizeLevel optimizeLevel) {
            this.builder.base.optimizeLevel = optimizeLevel;
            return this;
        }

        @Override
        public OptionalSteps<T, V> performanceImpact(PerformanceLevel performanceLevel) {
            this.builder.base.performanceLevel = performanceLevel;
            return this;
        }

        @Override
        public OptionalSteps<T, V> setContent(@NotNull DataContent content) {
            if (content instanceof DataContent.IntegerContent) {
                DataContent.IntegerContent ic = (DataContent.IntegerContent)content;
                this.builder.base.min = ic.min();
                this.builder.base.max = ic.max();
                this.builder.base.interVal = ic.interval();
                this.builder.base.format = ic.format();
            } else if (content instanceof DataContent.EnumContent) {
                DataContent.EnumContent ec = (DataContent.EnumContent)content;
                this.builder.base.texts = ec.texts();
            } else {
                throw new IllegalArgumentException("Unsupported DataContent type: " + String.valueOf(content.getClass()));
            }
            return this;
        }

        @Override
        public Base<V, T> build() {
            this.builder.base.implClass = this.builder.typeClass;
            return this.builder.base;
        }
    }

    public static interface OptionalSteps<T, V> {
        public OptionalSteps<T, V> compatLevel(CompatibilityLevel var1);

        public OptionalSteps<T, V> optimizeLevel(OptimizeLevel var1);

        public OptionalSteps<T, V> performanceImpact(PerformanceLevel var1);

        public OptionalSteps<T, V> setContent(@NotNull DataContent var1);

        public Base<V, T> build();
    }

    public static interface StepGetter<T, V> {
        public OptionalSteps<T, V> getter(Function<V, T> var1);
    }

    public static interface StepSetter<T, V> {
        public StepGetter<T, V> setter(BiConsumer<V, T> var1);
    }

    public static interface StepGroup<T, V> {
        public StepSetter<T, V> group(BaseUtil.Group var1);
    }

    public static interface StepKey<T, V> {
        public StepGroup<T, V> key(String var1);
    }
}

