/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.celeritas;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.taumc.celeritas.api.options.OptionIdentifier;
import org.taumc.celeritas.api.options.control.ControlValueFormatter;
import org.taumc.celeritas.api.options.control.CyclingControl;
import org.taumc.celeritas.api.options.control.SliderControl;
import org.taumc.celeritas.api.options.control.TickBoxControl;
import org.taumc.celeritas.api.options.structure.Option;
import org.taumc.celeritas.api.options.structure.OptionFlag;
import org.taumc.celeritas.api.options.structure.OptionGroup;
import org.taumc.celeritas.api.options.structure.OptionImpact;
import org.taumc.celeritas.api.options.structure.OptionImpl;
import org.taumc.celeritas.api.options.structure.OptionPage;
import org.taumc.celeritas.api.options.structure.OptionStorage;
import team.teampotato.ruok.gui.base.Base;
import team.teampotato.ruok.gui.base.BaseUtil;
import team.teampotato.ruok.gui.base.OptionManager;
import team.teampotato.ruok.gui.base.RuOKGameOptions;
import team.teampotato.ruok.gui.base.enumText.PerformanceLevel;
import team.teampotato.ruok.gui.celeritas.CeleritasOtherOptions;
import team.teampotato.ruok.gui.celeritas.PageId;
import team.teampotato.ruok.gui.celeritas.storage.OptionsStorage;

public class CeleritasOptions {
    private static final List<OptionGroup> hudGroup = new ArrayList<OptionGroup>();
    private static final List<OptionGroup> otherGroup = new ArrayList<OptionGroup>();
    private static final List<OptionGroup> mainGroup = new ArrayList<OptionGroup>();
    private static final OptionGroup.Builder mainBuilder = OptionGroup.createBuilder();
    private static final OptionGroup.Builder otherBuilder = OptionGroup.createBuilder();
    private static final OptionGroup.Builder hudBuilder = OptionGroup.createBuilder();
    private static final List<Base<RuOKGameOptions, ?>> adaptedBases = OptionManager.getBinds();

    public static List<OptionGroup> getHudGroup() {
        return hudGroup;
    }

    public static List<OptionGroup> getMainGroup() {
        return mainGroup;
    }

    @Contract(value=" -> new")
    @NotNull
    public static OptionPage getMainGroups() {
        if (CeleritasOptions.getMainGroup().isEmpty()) {
            CeleritasOptions.initMainGroup();
        }
        return new OptionPage(PageId.MAIN, TextComponent.translatable((String)"ruok.options.pages.ruok.main", (Object[])new Object[0]), (List)ImmutableList.copyOf(CeleritasOptions.getMainGroup()));
    }

    @Contract(value=" -> new")
    @NotNull
    public static OptionPage getOtherGroups() {
        if (CeleritasOptions.getOtherGroup().isEmpty()) {
            CeleritasOptions.initOtherGroup();
        }
        return new OptionPage(PageId.OTHER, TextComponent.translatable((String)"ruok.options.pages.ruok.other", (Object[])new Object[0]), (List)ImmutableList.copyOf(CeleritasOptions.getOtherGroup()));
    }

    @Contract(value=" -> new")
    @NotNull
    public static OptionPage getHudGroups() {
        if (CeleritasOptions.getHudGroup().isEmpty()) {
            CeleritasOptions.initHUDGroup();
        }
        return new OptionPage(PageId.HUD, TextComponent.translatable((String)"ruok.options.pages.ruok.hud", (Object[])new Object[0]), (List)ImmutableList.copyOf(CeleritasOptions.getHudGroup()));
    }

    public static List<OptionGroup> getOtherGroup() {
        return otherGroup;
    }

    public static void initGroup() {
        CeleritasOptions.initMainGroup();
        CeleritasOptions.initOtherGroup();
        CeleritasOptions.initHUDGroup();
    }

    private static void initHUDGroup() {
        CeleritasOptions.processGroup(BaseUtil.Group.HUD, hudBuilder);
        hudBuilder.add(CeleritasOtherOptions.getHUDConfigScreen());
        CeleritasOptions.getHudGroup().add(hudBuilder.setId(PageId.HUD).build());
    }

    private static void initMainGroup() {
        CeleritasOptions.processGroup(BaseUtil.Group.MAIN, mainBuilder);
        CeleritasOptions.getMainGroup().add(mainBuilder.setId(PageId.MAIN).build());
    }

    private static void initOtherGroup() {
        CeleritasOptions.processGroup(BaseUtil.Group.OTHER, otherBuilder);
        CeleritasOptions.getOtherGroup().add(otherBuilder.setId(PageId.OTHER).build());
    }

    private static void processGroup(BaseUtil.Group group, OptionGroup.Builder builder) {
        ArrayList baseList = new ArrayList();
        for (Base<RuOKGameOptions, Object> base : adaptedBases) {
            if (base.group != group) continue;
            baseList.add(base);
        }
        for (Base<RuOKGameOptions, Object> base : baseList) {
            if (BaseUtil.isBoolean(base)) {
                CeleritasOptions.processBoolean(base, builder);
            }
            if (BaseUtil.isInteger(base)) {
                CeleritasOptions.processInteger(base, builder);
            }
            if (!BaseUtil.isEnum(base)) continue;
            CeleritasOptions.processEnum(base, builder);
        }
    }

    private static void processBoolean(Base<RuOKGameOptions, Boolean> base, OptionGroup.Builder builder) {
        OptionImpl option = OptionImpl.createBuilder(Boolean.class, (OptionStorage)OptionsStorage.getOptionStorage()).setName(TextComponent.translatable((String)(base.key + ".info"), (Object[])new Object[0])).setTooltip(TextComponent.literal((String)class_2561.method_43471((String)(base.key + ".tooltip")).method_10852((class_2561)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel)).getString())).setControl(TickBoxControl::new).setBinding(base.biConsumer, base.function).setImpact(CeleritasOptions.getImpact(base)).setId(CeleritasOptions.getOptionId(base.key)).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build();
        builder.add((Option)option);
    }

    private static void processInteger(Base<RuOKGameOptions, Integer> base, OptionGroup.Builder builder) {
        OptionImpl option = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)OptionsStorage.getOptionStorage()).setName(TextComponent.translatable((String)(base.key + ".info"), (Object[])new Object[0])).setTooltip(TextComponent.literal((String)class_2561.method_43471((String)(base.key + ".tooltip")).method_10852((class_2561)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel)).getString())).setControl(o -> CeleritasOptions.getIntegerControl(base, (OptionImpl<RuOKGameOptions, Integer>)o)).setBinding(base.biConsumer, base.function).setImpact(CeleritasOptions.getImpact(base)).setId(CeleritasOptions.getOptionId(base.key)).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build();
        builder.add((Option)option);
    }

    @NotNull
    private static SliderControl getIntegerControl(Base<RuOKGameOptions, Integer> base, OptionImpl<RuOKGameOptions, Integer> optio) {
        return new SliderControl(optio, base.min, base.max, base.interVal, ControlValueFormatter.translateVariable((String)base.format));
    }

    private static void processEnum(@NotNull Base<RuOKGameOptions, ?> base, OptionGroup.Builder builder) {
        CeleritasOptions.addNewEnumOption(base, builder);
    }

    private static <T extends Enum<T>> void addNewEnumOption(Base<RuOKGameOptions, ?> rawBase, OptionGroup.Builder builder) {
        Base<RuOKGameOptions, ?> base = rawBase;
        Class enumClass = base.getEnumClass();
        OptionImpl option = OptionImpl.createBuilder(enumClass, (OptionStorage)OptionsStorage.getOptionStorage()).setName(TextComponent.translatable((String)(base.key + ".info"), (Object[])new Object[0])).setTooltip(TextComponent.literal((String)class_2561.method_43471((String)(base.key + ".tooltip")).method_10852((class_2561)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel)).getString())).setControl(o -> new CyclingControl((Option)o, enumClass, CeleritasOptions.textAdapter(base.texts))).setBinding(base.biConsumer, base.function).setImpact(CeleritasOptions.getImpact(base)).setId(CeleritasOptions.getOptionId(base.key)).build();
        builder.add((Option)option);
    }

    public static TextComponent @NotNull [] textAdapter(class_2561[] texts) {
        return (TextComponent[])Arrays.stream(texts).map(t -> TextComponent.translatable((String)t.getString(), (Object[])new Object[0])).toArray(TextComponent[]::new);
    }

    private static OptionImpact getImpact(Base<RuOKGameOptions, ?> base) {
        PerformanceLevel performanceLevel = base.performanceLevel;
        if (performanceLevel.equals(PerformanceLevel.HIGH)) {
            return OptionImpact.HIGH;
        }
        if (performanceLevel.equals(PerformanceLevel.MEDIUM)) {
            return OptionImpact.MEDIUM;
        }
        if (performanceLevel.equals(PerformanceLevel.LOW)) {
            return OptionImpact.LOW;
        }
        return OptionImpact.MEDIUM;
    }

    public static <T> OptionIdentifier<T> getOptionId(String key) {
        return OptionIdentifier.create((String)"ruokmod", (String)CeleritasOptions.getLastSegment(key).toLowerCase()).cast();
    }

    public static String getLastSegment(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        int lastDot = input.lastIndexOf(46);
        if (lastDot == -1 || lastDot == input.length() - 1) {
            return input;
        }
        return input.substring(lastDot + 1);
    }
}

