/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.option;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_7291;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.teampotato.ruok.RuOKMod;
import team.teampotato.ruok.gui.modern.widget.CyclingButtonWidget;
import team.teampotato.ruok.gui.modern.widget.option.OptionSliderWidget;

public class ModernOption<T> {
    public static final PotentialValuesBasedCallbacks<Boolean> BOOLEAN = new PotentialValuesBasedCallbacks(ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE));
    public static final ValueTextGetter<Boolean> BOOLEAN_TEXT_GETTER = (optionText, value) -> value != false ? class_5244.field_24332 : class_5244.field_24333;
    private final TooltipFactory<T> tooltipFactory;
    final Function<T, class_2561> textGetter;
    private final Callbacks<T> callbacks;
    private final T defaultValue;
    private final Consumer<T> changeCallback;
    final class_2561 text;
    T value;

    public static ModernOption<Boolean> ofBoolean(String key, boolean defaultValue, Consumer<Boolean> changeCallback) {
        return ModernOption.ofBoolean(key, ModernOption.emptyTooltip(), defaultValue, changeCallback);
    }

    public static ModernOption<Boolean> ofBoolean(String key, boolean defaultValue) {
        return ModernOption.ofBoolean(key, ModernOption.emptyTooltip(), defaultValue, value -> {});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ModernOption<Boolean> ofBoolean(String key, TooltipFactory<Boolean> tooltipFactory, boolean defaultValue) {
        return ModernOption.ofBoolean(key, tooltipFactory, defaultValue, value -> {});
    }

    public static ModernOption<Boolean> ofBoolean(String key, TooltipFactory<Boolean> tooltipFactory, boolean defaultValue, Consumer<Boolean> changeCallback) {
        return ModernOption.ofBoolean(key, tooltipFactory, BOOLEAN_TEXT_GETTER, defaultValue, changeCallback);
    }

    public static ModernOption<Boolean> ofBoolean(String key, TooltipFactory<Boolean> tooltipFactory, ValueTextGetter<Boolean> valueTextGetter, boolean defaultValue, Consumer<Boolean> changeCallback) {
        return new ModernOption<Boolean>(key, tooltipFactory, valueTextGetter, BOOLEAN, defaultValue, changeCallback);
    }

    public ModernOption(String key, TooltipFactory<T> tooltipFactory, ValueTextGetter<T> valueTextGetter, Callbacks<T> callbacks, T defaultValue, Consumer<T> changeCallback) {
        this.text = class_2561.method_43471((String)key);
        this.tooltipFactory = tooltipFactory;
        this.textGetter = value -> valueTextGetter.toString(this.text, value);
        this.callbacks = callbacks;
        this.defaultValue = defaultValue;
        this.changeCallback = changeCallback;
        this.value = this.defaultValue;
    }

    public static <T> TooltipFactory<T> emptyTooltip() {
        return value -> null;
    }

    public static <T> TooltipFactory<T> constantTooltip(class_2561 text) {
        return value -> class_7919.method_47407((class_2561)text);
    }

    public static <T extends class_7291> ValueTextGetter<T> enumValueText() {
        return (optionText, value) -> value.method_42627();
    }

    public class_339 createWidget(int x, int y, int width) {
        return this.createWidget(x, y, width, value -> {});
    }

    public class_339 createWidget(int x, int y, int width, Consumer<T> changeCallback) {
        return this.callbacks.getWidgetCreator(this.tooltipFactory, x, y, width, changeCallback).apply(this);
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.text.getString();
    }

    public void setValue(T value) {
        Object object = this.callbacks.validate(value).orElseGet(() -> {
            RuOKMod.LOGGER.error("Illegal option value {} for {}", value, (Object)this.text);
            return this.defaultValue;
        });
        if (!class_310.method_1551().method_22108()) {
            this.value = object;
        } else if (!Objects.equals(this.value, object)) {
            this.value = object;
            this.changeCallback.accept(this.value);
        }
    }

    public Callbacks<T> getCallbacks() {
        return this.callbacks;
    }

    @FunctionalInterface
    public static interface TooltipFactory<T> {
        @Nullable
        public class_7919 apply(T var1);
    }

    public static interface ValueTextGetter<T> {
        public class_2561 toString(class_2561 var1, T var2);
    }

    public record PotentialValuesBasedCallbacks<T>(List<T> values) implements CyclingCallbacks<T>
    {
        @Override
        public Optional<T> validate(T value) {
            return this.values.contains(value) ? Optional.of(value) : Optional.empty();
        }

        @Override
        public CyclingButtonWidget.Values<T> getValues() {
            return CyclingButtonWidget.Values.of(this.values);
        }
    }

    public static interface Callbacks<T> {
        public Function<ModernOption<T>, class_339> getWidgetCreator(TooltipFactory<T> var1, int var2, int var3, int var4, Consumer<T> var5);

        public Optional<T> validate(T var1);
    }

    public static interface SliderCallbacks<T>
    extends Callbacks<T> {
        public double toSliderProgress(T var1);

        public T toValue(double var1);

        @Override
        default public Function<ModernOption<T>, class_339> getWidgetCreator(TooltipFactory<T> tooltipFactory, int x, int y, int width, Consumer<T> changeCallback) {
            return option -> new OptionSliderWidgetImpl(x, y, width, 20, option, this, tooltipFactory, changeCallback);
        }
    }

    static interface CyclingCallbacks<T>
    extends Callbacks<T> {
        public CyclingButtonWidget.Values<T> getValues();

        default public ValueSetter<T> valueSetter() {
            return ModernOption::setValue;
        }

        @Override
        default public Function<ModernOption<T>, class_339> getWidgetCreator(TooltipFactory<T> tooltipFactory, int x, int y, int width, Consumer<T> changeCallback) {
            return option -> CyclingButtonWidget.builder(option.textGetter).values(this.getValues()).tooltip(tooltipFactory).initially(option.value).build(x, y, width, 20, option.text, (button, value) -> {
                this.valueSetter().set((ModernOption<Object>)option, value);
                changeCallback.accept(value);
            });
        }

        public static interface ValueSetter<T> {
            public void set(ModernOption<T> var1, T var2);
        }
    }

    static interface TypeChangeableCallbacks<T>
    extends CyclingCallbacks<T>,
    SliderCallbacks<T> {
        public boolean isCycling();

        @Override
        default public Function<ModernOption<T>, class_339> getWidgetCreator(TooltipFactory<T> tooltipFactory, int x, int y, int width, Consumer<T> changeCallback) {
            return this.isCycling() ? CyclingCallbacks.super.getWidgetCreator(tooltipFactory, x, y, width, changeCallback) : SliderCallbacks.super.getWidgetCreator(tooltipFactory, x, y, width, changeCallback);
        }
    }

    public record AlternateValuesSupportingCyclingCallbacks<T>(List<T> values, List<T> altValues, BooleanSupplier altCondition, CyclingCallbacks.ValueSetter<T> valueSetter) implements CyclingCallbacks<T>
    {
        @Override
        public CyclingButtonWidget.Values<T> getValues() {
            return CyclingButtonWidget.Values.of(this.altCondition, this.values, this.altValues);
        }

        @Override
        public Optional<T> validate(T value) {
            return (this.altCondition.getAsBoolean() ? this.altValues : this.values).contains(value) ? Optional.of(value) : Optional.empty();
        }
    }

    public record LazyCyclingCallbacks<T>(Supplier<List<T>> values, Function<T, Optional<T>> validateValue) implements CyclingCallbacks<T>
    {
        @Override
        public Optional<T> validate(T value) {
            return this.validateValue.apply(value);
        }

        @Override
        public CyclingButtonWidget.Values<T> getValues() {
            return CyclingButtonWidget.Values.of((Collection)this.values.get());
        }
    }

    private static final class OptionSliderWidgetImpl<N>
    extends OptionSliderWidget {
        private final ModernOption<N> option;
        private final SliderCallbacks<N> callbacks;
        private final TooltipFactory<N> tooltipFactory;
        private final Consumer<N> changeCallback;

        OptionSliderWidgetImpl(int x, int y, int width, int height, ModernOption<N> option, SliderCallbacks<N> callbacks, TooltipFactory<N> tooltipFactory, Consumer<N> changeCallback) {
            super(x, y, width, height, callbacks.toSliderProgress(option.getValue()));
            this.option = option;
            this.callbacks = callbacks;
            this.tooltipFactory = tooltipFactory;
            this.changeCallback = changeCallback;
            this.method_25346();
        }

        protected void method_25346() {
            this.method_25355(this.option.textGetter.apply(this.option.getValue()));
            this.method_47400(this.tooltipFactory.apply(this.callbacks.toValue(this.field_22753)));
        }

        protected void method_25344() {
            this.option.setValue(this.callbacks.toValue(this.field_22753));
            this.changeCallback.accept(this.option.getValue());
        }
    }

    static interface IntSliderCallbacks
    extends SliderCallbacks<Integer> {
        public int minInclusive();

        public int maxInclusive();

        @Override
        default public double toSliderProgress(Integer integer) {
            return class_3532.method_37959((float)integer.intValue(), (float)this.minInclusive(), (float)this.maxInclusive(), (float)0.0f, (float)1.0f);
        }

        @Override
        default public Integer toValue(double d) {
            return class_3532.method_15357((double)class_3532.method_33722((double)d, (double)0.0, (double)1.0, (double)this.minInclusive(), (double)this.maxInclusive()));
        }

        default public <R> SliderCallbacks<R> withModifier(final IntFunction<? extends R> sliderProgressValueToValue, final ToIntFunction<? super R> valueToSliderProgressValue) {
            return new SliderCallbacks<R>(){

                @Override
                public Optional<R> validate(R value) {
                    Optional<Integer> var10000 = this.validate(valueToSliderProgressValue.applyAsInt(value));
                    Objects.requireNonNull(sliderProgressValueToValue);
                    return var10000.map(sliderProgressValueToValue::apply);
                }

                @Override
                public double toSliderProgress(R value) {
                    return this.toSliderProgress(valueToSliderProgressValue.applyAsInt(value));
                }

                @Override
                public R toValue(double sliderProgress) {
                    return sliderProgressValueToValue.apply(this.toValue(sliderProgress));
                }
            };
        }
    }

    public record ValidatingIntSliderCallbacks(int minInclusive, int maxInclusive) implements IntSliderCallbacks
    {
        @Override
        public Optional<Integer> validate(Integer integer) {
            return integer.compareTo(this.minInclusive()) >= 0 && integer.compareTo(this.maxInclusive()) <= 0 ? Optional.of(integer) : Optional.empty();
        }
    }

    public record MaxSuppliableIntCallbacks(int minInclusive, IntSupplier maxSupplier, int encodableMaxInclusive) implements IntSliderCallbacks,
    TypeChangeableCallbacks<Integer>
    {
        @Override
        public Optional<Integer> validate(Integer integer) {
            return Optional.of(class_3532.method_15340((int)integer, (int)this.minInclusive(), (int)this.maxInclusive()));
        }

        @Override
        public int maxInclusive() {
            return this.maxSupplier.getAsInt();
        }

        @Override
        public boolean isCycling() {
            return true;
        }

        @Override
        public CyclingButtonWidget.Values<Integer> getValues() {
            return CyclingButtonWidget.Values.of(IntStream.range(this.minInclusive, this.maxInclusive() + 1).boxed().toList());
        }
    }

    public static enum DoubleSliderCallbacks implements SliderCallbacks<Double>
    {
        INSTANCE;


        @Override
        public Optional<Double> validate(Double double_) {
            return double_ >= 0.0 && double_ <= 1.0 ? Optional.of(double_) : Optional.empty();
        }

        @Override
        public double toSliderProgress(Double double_) {
            return double_;
        }

        @Override
        public Double toValue(double d) {
            return d;
        }

        public <R> SliderCallbacks<R> withModifier(final DoubleFunction<? extends R> sliderProgressValueToValue, final ToDoubleFunction<? super R> valueToSliderProgressValue) {
            return new SliderCallbacks<R>(){

                @Override
                public Optional<R> validate(R value) {
                    Optional<Double> var10000 = this.validate(valueToSliderProgressValue.applyAsDouble(value));
                    Objects.requireNonNull(sliderProgressValueToValue);
                    return var10000.map(sliderProgressValueToValue::apply);
                }

                @Override
                public double toSliderProgress(R value) {
                    return this.toSliderProgress(valueToSliderProgressValue.applyAsDouble(value));
                }

                @Override
                public R toValue(double sliderProgress) {
                    return sliderProgressValueToValue.apply(this.toValue(sliderProgress));
                }
            };
        }
    }
}

