/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.teampotato.ruok.gui.modern.option.ModernOption;
import team.teampotato.ruok.util.ColorUtil;

@Environment(value=EnvType.CLIENT)
public class CyclingButtonWidget<T>
extends class_4264 {
    public static final BooleanSupplier HAS_ALT_DOWN = class_437::method_25443;
    private static final List<Boolean> BOOLEAN_VALUES = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    private int index;
    private T value;
    private final Values<T> values;
    private final Function<T, class_2561> valueToText;
    private final Function<CyclingButtonWidget<T>, class_5250> narrationMessageFactory;
    private final UpdateCallback<T> callback;
    private final boolean optionTextOmitted;
    private final ModernOption.TooltipFactory<T> tooltipFactory;
    private double buttonX;
    private final double animationSpeed = 0.15;

    CyclingButtonWidget(int x, int y, int width, int height, class_2561 message, int index, T value, Values<T> values, Function<T, class_2561> valueToText, Function<CyclingButtonWidget<T>, class_5250> narrationMessageFactory, UpdateCallback<T> callback, ModernOption.TooltipFactory<T> tooltipFactory, boolean optionTextOmitted) {
        super(x, y, width, height, message);
        this.buttonX = this.field_22758 + this.method_46426();
        this.animationSpeed = 0.15;
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueToText = valueToText;
        this.narrationMessageFactory = narrationMessageFactory;
        this.callback = callback;
        this.optionTextOmitted = optionTextOmitted;
        this.tooltipFactory = tooltipFactory;
        this.refreshTooltip();
    }

    private void refreshTooltip() {
        this.method_47400(this.tooltipFactory.apply(this.value));
    }

    public void method_25306() {
        if (class_437.method_25442()) {
            this.cycle(-1);
        } else {
            this.cycle(1);
        }
    }

    public int getValueInt() {
        T object = this.getValue(1);
        if (object instanceof Boolean) {
            Boolean e = (Boolean)object;
            return e != false ? 1 : 0;
        }
        if (object instanceof Enum) {
            Enum e = (Enum)object;
            return e.ordinal();
        }
        return -1;
    }

    public int getValueMaxInt() {
        Enum e;
        Enum[] values;
        T object = this.getValue(1);
        if (object instanceof Enum && (values = (Enum[])(e = (Enum)object).getDeclaringClass().getEnumConstants()) != null && values.length > 0) {
            return values[values.length - 1].ordinal();
        }
        if (object instanceof Boolean) {
            return 1;
        }
        return -1;
    }

    public class_5250 getValueToText() {
        T object = this.getValue(1);
        class_2561 text = this.valueToText.apply(object);
        return class_2561.method_43473().method_10852(text);
    }

    public boolean isEnum() {
        return this.value instanceof Enum;
    }

    protected void method_48579(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        class_310 minecraftClient = class_310.method_1551();
        context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int alphaValue = class_3532.method_15386((float)(this.field_22765 * 255.0f));
        int color = this.method_25367() ? ColorUtil.getAUIColor(-804253680, 0.8) : ColorUtil.getAUIColor(-804253680, 0.5);
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), color);
        if (!this.isEnum()) {
            this.renderBooleanButton(context);
        } else {
            this.renderButtonSetting(context, mouseX, mouseY, delta);
        }
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.method_48589(context, minecraftClient.field_1772, i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    public void method_48589(class_332 context, class_327 textRenderer, int color) {
        this.method_49604(context, textRenderer, 2, color);
    }

    public void method_49604(class_332 context, class_327 textRenderer, int xMargin, int color) {
        int left = this.method_46426() + xMargin + 5;
        int right = this.method_46426() + this.method_25368() - xMargin;
        CyclingButtonWidget.drawScrollableText(context, textRenderer, this.method_25369(), left, this.method_46427(), right, this.method_46427() + this.method_25364(), color);
    }

    public static void drawScrollableText(class_332 context, class_327 textRenderer, class_2561 text, int left, int top, int right, int bottom, int color) {
        int textWidth = textRenderer.method_27525((class_5348)text);
        int textHeight = 9;
        int centerY = (top + bottom - textHeight) / 2 + 1;
        int maxWidth = right - left;
        if (textWidth > maxWidth) {
            int overflowWidth = textWidth - maxWidth;
            double time = (double)class_156.method_658() / 1000.0;
            double scrollSpeed = Math.max((double)overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * time / scrollSpeed)) / 2.0 + 0.5;
            double scrollX = class_3532.method_16436((double)scrollFactor, (double)0.0, (double)overflowWidth);
            context.method_44379(left, top, right, bottom);
            context.method_27535(textRenderer, text, left - (int)scrollX, centerY, color);
            context.method_44380();
        } else {
            context.method_27535(textRenderer, text, left, centerY, color);
        }
    }

    public void renderButtonSetting(class_332 context, int mouseX, int mouseY, float delta) {
        class_310 mc = class_310.method_1551();
        int endX = this.field_22758 + this.method_46426();
        int textX = endX - 33;
        int y = this.method_46427();
        int maxLevel = this.getValueMaxInt() + 1;
        int spacing = 8;
        int totalWidth = (maxLevel - 1) * spacing;
        int lineXStart = endX - totalWidth / 2 - 30;
        int textColor = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        class_5250 text = this.getValueToText();
        context.method_51439(mc.field_1772, (class_2561)text, textX, y + 3, textColor, false);
        int level = this.getValueInt();
        for (int i = 0; i < maxLevel; ++i) {
            int color = i == level ? -7798904 : -7829368;
            int lineX = lineXStart + i * spacing;
            int lineY = y + this.field_22759 / 2 + 2 + 3;
            context.method_25294(lineX, lineY, lineX + 6, lineY + 2, color);
        }
    }

    public void method_53533(int height) {
        this.field_22759 = height;
    }

    public int method_25364() {
        return super.method_25364();
    }

    protected void renderBooleanButton(@NotNull class_332 context) {
        int endX = this.field_22758 + this.method_46426();
        int fillXStart = endX - 15;
        int fillXEnd = endX - 5;
        int z = 7;
        boolean buttonOn = this.getValueInt() == 0;
        int targetButtonX = buttonOn ? fillXStart + 3 : fillXEnd - 17;
        this.buttonX = this.lerp(this.buttonX, targetButtonX, 0.15);
        int startColor = -7829368;
        int endColor = -7798904;
        int bgColor = this.lerpColor(startColor, endColor, buttonOn ? 1.0f : 0.0f);
        context.method_25294(fillXStart - 8, this.method_46427() + this.field_22759 / 2 + 1, fillXEnd, this.method_46427() + this.field_22759 / 2 - 1, bgColor);
        context.method_25294((int)this.buttonX - 1, this.method_46427() + z, (int)this.buttonX + 8, this.method_46427() + this.field_22759 - z, -1);
    }

    private double lerp(double from, double to, double progress) {
        return from + (to - from) * progress;
    }

    private int lerpColor(int startColor, int endColor, float progress) {
        int startA = startColor >> 24 & 0xFF;
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endA = endColor >> 24 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int newA = (int)this.lerp(startA, endA, progress);
        int newR = (int)this.lerp(startR, endR, progress);
        int newG = (int)this.lerp(startG, endG, progress);
        int newB = (int)this.lerp(startB, endB, progress);
        return newA << 24 | newR << 16 | newG << 8 | newB;
    }

    private void cycle(int amount) {
        List<T> list = this.values.getCurrent();
        this.index = class_3532.method_15387((int)(this.index + amount), (int)list.size());
        T object = list.get(this.index);
        this.internalSetValue(object);
        this.callback.onValueChange(this, object);
    }

    private T getValue(int offset) {
        List<T> list = this.values.getCurrent();
        return list.get(class_3532.method_15387((int)(this.index + offset), (int)list.size()));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.cycle(-1);
        } else if (amount < 0.0) {
            this.cycle(1);
        }
        return true;
    }

    public void setValue(T value) {
        List<T> list = this.values.getCurrent();
        int i = list.indexOf(value);
        if (i != -1) {
            this.index = i;
        }
        this.internalSetValue(value);
    }

    private void internalSetValue(T value) {
        this.value = value;
        this.refreshTooltip();
    }

    public T getValue() {
        return this.value;
    }

    protected class_5250 method_25360() {
        return this.narrationMessageFactory.apply(this);
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            T object = this.getValue(1);
            class_2561 text = this.valueToText.apply(object);
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{text}));
            } else {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{text}));
            }
        }
    }

    public static <T> Builder<T> builder(Function<T, class_2561> valueToText) {
        return new Builder<T>(valueToText);
    }

    public static Builder<Boolean> onOffBuilder(class_2561 on, class_2561 off) {
        return new Builder<Boolean>(value -> value != false ? on : off).values((Collection<Boolean>)BOOLEAN_VALUES);
    }

    public static Builder<Boolean> onOffBuilder() {
        return new Builder<Boolean>(value -> value != false ? class_5244.field_24332 : class_5244.field_24333).values((Collection<Boolean>)BOOLEAN_VALUES);
    }

    public static Builder<Boolean> onOffBuilder(boolean initialValue) {
        return CyclingButtonWidget.onOffBuilder().initially(initialValue);
    }

    public boolean isOptionTextOmitted() {
        return this.optionTextOmitted;
    }

    private class_5250 getMessageMutable() {
        return class_2561.method_43473().method_10852(this.method_25369());
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Values<T> {
        public List<T> getCurrent();

        public List<T> getDefaults();

        public static <T> Values<T> of(Collection<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new Values<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getCurrent() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }

        public static <T> Values<T> of(final BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
            ImmutableList list = ImmutableList.copyOf(defaults);
            ImmutableList list2 = ImmutableList.copyOf(alternatives);
            return new Values<T>(){
                final /* synthetic */ List val$list2;
                final /* synthetic */ List val$list;
                {
                    this.val$list2 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getCurrent() {
                    return alternativeToggle.getAsBoolean() ? this.val$list2 : this.val$list;
                }

                @Override
                public List<T> getDefaults() {
                    return this.val$list;
                }
            };
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface UpdateCallback<T> {
        public void onValueChange(CyclingButtonWidget<T> var1, T var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder<T> {
        private int initialIndex;
        @Nullable
        private T value;
        private final Function<T, class_2561> valueToText;
        private ModernOption.TooltipFactory<T> tooltipFactory = value -> null;
        private Function<CyclingButtonWidget<T>, class_5250> narrationMessageFactory = CyclingButtonWidget::getMessageMutable;
        private Values<T> values = Values.of(ImmutableList.of());
        private boolean optionTextOmitted;

        public Builder(Function<T, class_2561> valueToText) {
            this.valueToText = valueToText;
        }

        public Builder<T> values(Collection<T> values) {
            return this.values(Values.of(values));
        }

        @SafeVarargs
        public final Builder<T> values(T ... values) {
            return this.values((Collection<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> values(List<T> defaults, List<T> alternatives) {
            return this.values(Values.of(HAS_ALT_DOWN, defaults, alternatives));
        }

        public Builder<T> values(BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
            return this.values(Values.of(alternativeToggle, defaults, alternatives));
        }

        public Builder<T> values(Values<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> tooltip(ModernOption.TooltipFactory<T> tooltipFactory) {
            this.tooltipFactory = tooltipFactory;
            return this;
        }

        public Builder<T> initially(T value) {
            this.value = value;
            int i = this.values.getDefaults().indexOf(value);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public Builder<T> narration(Function<CyclingButtonWidget<T>, class_5250> narrationMessageFactory) {
            this.narrationMessageFactory = narrationMessageFactory;
            return this;
        }

        public Builder<T> omitKeyText() {
            this.optionTextOmitted = true;
            return this;
        }

        public CyclingButtonWidget<T> build(int x, int y, int width, int height, class_2561 optionText) {
            return this.build(x, y, width, height, optionText, (button, value) -> {});
        }

        public CyclingButtonWidget<T> build(int x, int y, int width, int height, class_2561 optionText, UpdateCallback<T> callback) {
            List<T> list = this.values.getDefaults();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T object = this.value != null ? this.value : list.get(this.initialIndex);
            class_2561 text = this.valueToText.apply(object);
            class_2561 text2 = this.optionTextOmitted ? text : class_5244.method_32700((class_2561)optionText, (class_2561)text);
            return new CyclingButtonWidget<T>(x, y, width, height, optionText, this.initialIndex, object, this.values, this.valueToText, this.narrationMessageFactory, callback, this.tooltipFactory, this.optionTextOmitted);
        }
    }
}

