/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.hook;

import net.minecraft.class_310;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.GameSystemMonitor;
import team.teampotato.ruok.util.TaskManager;
import team.teampotato.ruok.util.clazz.jfr.JFRManager;
import team.teampotato.ruok.util.entity.EntityDebugUtil;
import team.teampotato.ruok.util.entity.EntityUtils;
import team.teampotato.ruok.util.hook.HookDispatcher;
import team.teampotato.ruok.util.particle.ParticleTaskManager;
import team.teampotato.ruok.util.render.TextRender;

public class HookManager {
    public static void init() {
        HookDispatcher.register(HookDispatcher.HookType.STOP, TaskManager::autoShutdown);
        HookDispatcher.register(HookDispatcher.HookType.STOP, JFRManager::stop);
        HookDispatcher.register(HookDispatcher.HookType.WORLD_DISCONNECT, ParticleTaskManager::onCleanPoolMemory);
        HookDispatcher.register(HookDispatcher.HookType.TICK, () -> {
            EntityDebugUtil.tickEntityViewDebug();
            TaskManager.runAsync(() -> {
                if (GameSystemMonitor.isInitState()) {
                    GameSystemMonitor.run(class_310.method_1551());
                }
            });
        });
        HookManager.addAsync();
    }

    public static void addAsync() {
        HookDispatcher.register(HookDispatcher.HookType.TICK, () -> {
            HookManager.asyncFast(EntityUtils::refViewEntity);
            if (RuOK.get().Hud && class_310.method_1551().field_1687 != null) {
                TextRender.refInfo();
            }
        });
    }

    public static void asyncFast(Runnable runnable) {
        if (RuOK.get().AsyncCompute) {
            TaskManager.runAsyncFast(runnable);
        } else {
            runnable.run();
        }
    }
}

