/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.particle;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_703;
import net.minecraft.class_733;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.TaskManager;
import team.teampotato.ruok.util.particle.ParticleRender;

public class ParticleTaskManager {
    private static final Map<Class<? extends class_703>, Queue<class_703>> POOL = new ConcurrentHashMap<Class<? extends class_703>, Queue<class_703>>();
    private static final ThreadLocal<Map<class_3999, List<class_703>>> THREAD_PARTICLE_MAP = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<List<class_733>> THREAD_EMITTER_LIST = ThreadLocal.withInitial(ArrayList::new);
    private static final ThreadLocal<List<class_703>> THREAD_NEW_PARTICLE_LIST = ThreadLocal.withInitial(ArrayList::new);
    private static final Map<class_3999, Queue<class_703>> queueCache = new HashMap<class_3999, Queue<class_703>>();
    private static final AtomicInteger currentTotal = new AtomicInteger(0);
    private static final AtomicInteger droppedNewParticles = new AtomicInteger(0);
    private static final Map<Class<? extends class_703>, AtomicInteger> createdCountMap = new ConcurrentHashMap<Class<? extends class_703>, AtomicInteger>();
    private static final Map<Class<? extends class_703>, AtomicInteger> recycledCountMap = new ConcurrentHashMap<Class<? extends class_703>, AtomicInteger>();

    private static Queue<class_703> getOrCreateQueue(class_3999 sheet) {
        return queueCache.computeIfAbsent(sheet, s -> EvictingQueue.create((int)ParticleTaskManager.getMaxParticlesCount()));
    }

    public static void processParticles(Map<class_3999, Queue<class_703>> particles, Queue<class_733> emitters, @NotNull Queue<class_703> newParticlesQueue, Consumer<ParticleMergeResult> onComplete) {
        class_703 p;
        HashMap particlesSnapshot = new HashMap();
        for (Map.Entry<class_3999, Queue<class_703>> entry : particles.entrySet()) {
            particlesSnapshot.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        ArrayList<class_733> emittersSnapshot = new ArrayList<class_733>(emitters);
        List<class_703> newParticlesBatch = THREAD_NEW_PARTICLE_LIST.get();
        newParticlesBatch.clear();
        while ((p = newParticlesQueue.poll()) != null) {
            newParticlesBatch.add(p);
        }
        ConcurrentHashMap resultMap = new ConcurrentHashMap();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (class_310.method_1551().method_1493()) {
            return;
        }
        for (Map.Entry entry : particlesSnapshot.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                ArrayList<class_703> updatedList = new ArrayList<class_703>();
                for (class_703 particle : (List)entry.getValue()) {
                    if (!ParticleRender.shouldRawRender(particle)) {
                        ParticleTaskManager.recycleParticle(particle);
                        continue;
                    }
                    try {
                        particle.method_3070();
                    }
                    catch (Exception e) {
                        ParticleTaskManager.recycleParticle(particle);
                        continue;
                    }
                    if (particle.method_3086()) {
                        updatedList.add(particle);
                        continue;
                    }
                    ParticleTaskManager.recycleParticle(particle);
                }
                resultMap.put((class_3999)entry.getKey(), updatedList);
            }, ForkJoinPool.commonPool()));
        }
        CompletableFuture<Void> emitterFuture = CompletableFuture.runAsync(() -> {
            List<class_733> updatedEmitters = THREAD_EMITTER_LIST.get();
            updatedEmitters.clear();
            for (class_733 emitter : emittersSnapshot) {
                try {
                    emitter.method_3070();
                    if (!emitter.method_3086()) continue;
                    updatedEmitters.add(emitter);
                }
                catch (Exception exception) {}
            }
        }, ForkJoinPool.commonPool());
        CompletableFuture.allOf((CompletableFuture[])Stream.concat(futures.stream(), Stream.of(emitterFuture)).toArray(CompletableFuture[]::new)).thenRunAsync(() -> {
            HashMap<class_3999, List<class_703>> finalCopy = new HashMap<class_3999, List<class_703>>();
            for (Map.Entry entry : resultMap.entrySet()) {
                finalCopy.put((class_3999)entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            ArrayList<class_733> updatedEmitters = new ArrayList<class_733>((Collection)THREAD_EMITTER_LIST.get());
            ArrayList<class_703> newParticles = new ArrayList<class_703>(newParticlesBatch);
            onComplete.accept(new ParticleMergeResult(finalCopy, updatedEmitters, newParticles));
        }, TaskManager.getAsyncExecutor());
    }

    public static void applyResults(ParticleMergeResult result, Map<class_3999, Queue<class_703>> mainParticles, Queue<class_733> emitterParticles) {
        Queue queue;
        class_3999 sheet;
        int maxTotalParticles = ParticleTaskManager.getMaxParticlesCount();
        int current = 0;
        int dropped = 0;
        HashMap<class_3999, Queue> queueMap = new HashMap<class_3999, Queue>();
        for (class_3999 class_39992 : result.updated.keySet()) {
            queueMap.put(class_39992, mainParticles.computeIfAbsent(class_39992, ParticleTaskManager::getOrCreateQueue));
        }
        mainParticles.values().forEach(Collection::clear);
        for (Map.Entry entry : result.updated.entrySet()) {
            List particles;
            sheet = (class_3999)entry.getKey();
            queue = (Queue)queueMap.get(sheet);
            if (queue == null || (particles = (List)entry.getValue()) == null || particles.isEmpty()) continue;
            int limit = Math.min(particles.size(), maxTotalParticles - current);
            for (int i = 0; i < limit; ++i) {
                class_703 p = (class_703)particles.get(i);
                if (p == null) continue;
                queue.add(p);
                ++current;
            }
            if (current < maxTotalParticles) continue;
            break;
        }
        emitterParticles.clear();
        for (class_733 class_7332 : result.emitters) {
            if (class_7332 == null) continue;
            emitterParticles.add(class_7332);
        }
        for (class_703 class_7032 : result.newParticles) {
            if (class_7032 == null) continue;
            if (current >= maxTotalParticles) {
                ++dropped;
                continue;
            }
            sheet = class_7032.method_18122();
            queue = queueMap.computeIfAbsent(sheet, k -> mainParticles.computeIfAbsent((class_3999)k, ParticleTaskManager::getOrCreateQueue));
            queue.add(class_7032);
            ++current;
        }
        currentTotal.set(current);
        droppedNewParticles.set(dropped);
    }

    public static <T extends class_703> T obtain(Class<T> cls, Supplier<T> creator) {
        Queue pool = POOL.computeIfAbsent(cls, k -> new ConcurrentLinkedQueue());
        class_703 p = (class_703)pool.poll();
        class_703 instance = (class_703)cls.cast(p != null ? p : creator.get());
        createdCountMap.computeIfAbsent(cls, k -> new AtomicInteger()).incrementAndGet();
        return (T)instance;
    }

    public static <T extends class_703> void recycleParticle(T particle) {
        if (particle == null) {
            return;
        }
        Queue pool = POOL.computeIfAbsent(particle.getClass(), k -> new ArrayDeque());
        recycledCountMap.computeIfAbsent(particle.getClass(), k -> new AtomicInteger()).incrementAndGet();
        if (pool.size() > 8192) {
            return;
        }
        particle.method_3085();
        pool.offer(particle);
    }

    public static void onMemoryCleanup() {
        ParticleTaskManager.clearPool();
        queueCache.clear();
        THREAD_PARTICLE_MAP.remove();
        THREAD_EMITTER_LIST.remove();
        THREAD_NEW_PARTICLE_LIST.remove();
    }

    public static void onCleanPoolMemory() {
        ParticleTaskManager.onMemoryCleanup();
        ParticleTaskManager.cleanParticlePool();
    }

    public static void clearPool() {
        POOL.clear();
    }

    public static void cleanParticlePool() {
        int maxSize = 2048;
        for (Map.Entry<Class<? extends class_703>, Queue<class_703>> entry : POOL.entrySet()) {
            Queue<class_703> queue = entry.getValue();
            if (queue.size() <= maxSize) continue;
            int toRemove = queue.size() - maxSize;
            for (int i = 0; i < toRemove; ++i) {
                queue.poll();
            }
        }
    }

    public static int getParticlePoolCount() {
        return POOL.values().stream().mapToInt(Collection::size).sum();
    }

    public static int getMaxParticlesCount() {
        return RuOK.get().ParticleCountLimit;
    }

    public static int getDroppedNewParticles() {
        return droppedNewParticles.get();
    }

    public static int getCurrentParticleCount() {
        return currentTotal.get();
    }

    public static class_2561 buildDebugInfo() {
        int pool = ParticleTaskManager.getParticlePoolCount();
        int cur = ParticleTaskManager.getCurrentParticleCount();
        int drop = ParticleTaskManager.getDroppedNewParticles();
        return class_2561.method_43469((String)"ruok.quality.particle.debug", (Object[])new Object[]{pool, cur, drop});
    }

    public record ParticleMergeResult(Map<class_3999, List<class_703>> updated, List<class_733> emitters, List<class_703> newParticles) {
    }
}

