/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.render;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_746;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.config.RuOKConfig;
import team.teampotato.ruok.util.FPSUtil;
import team.teampotato.ruok.util.OSysInfo;
import team.teampotato.ruok.util.render.text.LocalServerInfo;

public class TextRender {
    private static final class_310 mc = class_310.method_1551();
    private static int maxFPS = 0;
    private static class_2561 GPU_TEXT = TextRender.formatColor((int)Math.min(class_310.method_1551().method_41734(), 100.0));
    private static int delay = 0;
    private static int delayText = 0;
    private static class_2561 RAM_TEXT = TextRender.getRamText();
    private static class_2561 CPU_TEXT = TextRender.getCPUText();
    private static class_2561 CAMERA_TO_BLOCK = TextRender.getBlockToPlayerPos();

    public static class_5250 formatColor(int v) {
        class_5250 text = class_2561.method_43470((String)String.valueOf(v));
        if (v > 80) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1061));
        }
        if (v > 70) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1054));
        }
        if (v > 30) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1060));
        }
        return text.method_10862(text.method_10866().method_10977(class_124.field_1060));
    }

    public static class_2561 formatFpsColor(int fps) {
        class_5250 text = class_2561.method_43470((String)String.valueOf(fps));
        if (fps > 58) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1060));
        }
        if (fps > 48) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1054));
        }
        if (fps > 28) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1065));
        }
        return text.method_10862(text.method_10866().method_10977(class_124.field_1061));
    }

    public static class_2561 formatRXTXColor(float v) {
        class_5250 text = class_2561.method_43470((String)String.valueOf(v));
        if (v > 3000.0f) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1061));
        }
        if (v > 2000.0f) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1065));
        }
        if (v > 1000.0f) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1054));
        }
        if (v > 500.0f) {
            return text.method_10862(text.method_10866().method_10977(class_124.field_1060));
        }
        return text.method_10862(text.method_10866().method_10977(class_124.field_1060));
    }

    public static void draw(class_332 context, class_310 mc) {
        if (RuOK.get().Hud) {
            TextRender.drawText(context, mc);
        }
    }

    private static void drawText(class_332 context, @NotNull class_310 mc) {
        if (mc.field_1687 != null) {
            class_327 tr = mc.field_1772;
            int color = -1;
            if (!mc.field_1705.method_53531().method_53536()) {
                int textHeight;
                int textWidth;
                int n;
                int x;
                RuOKConfig config = RuOK.get();
                if (config.GuiX != 0) {
                    v0 = config.GuiX;
                } else {
                    Objects.requireNonNull(tr);
                    v0 = x = 9 / 2;
                }
                if (config.GuiY != 0) {
                    n = config.GuiY;
                } else {
                    Objects.requireNonNull(tr);
                    n = 9 / 2;
                }
                int y = n;
                Objects.requireNonNull(tr);
                int fh = 9 + 4;
                if (RuOK.get().HudFPS) {
                    int currentFPS = class_310.method_1551().method_47599();
                    if (currentFPS > maxFPS) {
                        maxFPS = currentFPS;
                    }
                    FPSUtil.addFPS(currentFPS);
                    long averageFPS = Math.round(FPSUtil.getAverageFPS());
                    class_5250 fpsText = class_2561.method_43469((String)"ruok.options.gui.fps", (Object[])new Object[]{TextRender.formatFpsColor(currentFPS), TextRender.formatFpsColor((int)averageFPS), TextRender.formatFpsColor(maxFPS)});
                    int textWidth2 = tr.method_27525((class_5348)fpsText);
                    Objects.requireNonNull(tr);
                    int textHeight2 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth2, textHeight2);
                    context.method_51439(tr, (class_2561)fpsText, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().HudCPU || RuOK.get().HudRAM || RuOK.get().HudEntityCount || RuOK.get().HudGPU) {
                    class_5250 info = class_2561.method_43473();
                    boolean addSeparator = false;
                    if (RuOK.get().HudCPU) {
                        info.method_10852((class_2561)class_2561.method_43469((String)"ruok.options.gui.cpu", (Object[])new Object[]{CPU_TEXT}));
                        addSeparator = true;
                    }
                    if (RuOK.get().HudGPU) {
                        if (addSeparator) {
                            info.method_10852(class_2561.method_30163((String)" | "));
                        }
                        info.method_10852((class_2561)class_2561.method_43469((String)"ruok.options.gui.gpu", (Object[])new Object[]{GPU_TEXT}));
                        addSeparator = true;
                    }
                    if (RuOK.get().HudRAM) {
                        if (addSeparator) {
                            info.method_10852(class_2561.method_30163((String)" | "));
                        }
                        info.method_10852((class_2561)class_2561.method_43469((String)"ruok.options.gui.mem", (Object[])new Object[]{RAM_TEXT}));
                        addSeparator = true;
                    }
                    if (RuOK.get().HudEntityCount) {
                        if (addSeparator) {
                            info.method_10852(class_2561.method_30163((String)" | "));
                        }
                        info.method_10852(TextRender.getEntityCount(mc.field_1687));
                    }
                    textWidth = tr.method_27525((class_5348)info);
                    Objects.requireNonNull(tr);
                    int textHeight3 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth, textHeight3);
                    context.method_51439(tr, (class_2561)info, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().HudPlayerPos && mc.field_1724 != null) {
                    class_746 p = mc.field_1724;
                    class_5250 posText = class_2561.method_43469((String)"ruok.options.gui.player.pos", (Object[])new Object[]{TextRender.dis(p.method_23317()), TextRender.dis(p.method_23318()), TextRender.dis(p.method_23321())});
                    textWidth = tr.method_27525((class_5348)posText);
                    Objects.requireNonNull(tr);
                    int textHeight4 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth, textHeight4);
                    context.method_51439(tr, (class_2561)posText, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().HudServer) {
                    class_2561 serverText = mc.method_1576() != null ? LocalServerInfo.getLocalServerInfoText() : TextRender.getRemoteServerPing(mc);
                    int textWidth3 = tr.method_27525((class_5348)serverText);
                    Objects.requireNonNull(tr);
                    textHeight = 9;
                    TextRender.addTextShadow(context, x, y, textWidth3, textHeight);
                    context.method_51439(tr, serverText, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().HudCameraTarget) {
                    int textWidth4 = tr.method_27525((class_5348)CAMERA_TO_BLOCK);
                    Objects.requireNonNull(tr);
                    int textHeight5 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth4, textHeight5);
                    context.method_51439(tr, CAMERA_TO_BLOCK, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().HudRXTX) {
                    class_2561 serverIOText = TextRender.getRXTXData(mc);
                    int textWidth5 = tr.method_27525((class_5348)serverIOText);
                    Objects.requireNonNull(tr);
                    textHeight = 9;
                    TextRender.addTextShadow(context, x, y, textWidth5, textHeight);
                    context.method_51439(tr, serverIOText, x, y, color, true);
                }
            }
        }
    }

    private static void addTextShadow(class_332 context, int x, int y, int textWidth, int textHeight) {
        if (RuOK.get().TextBackground) {
            int shadowOffset = 2;
            context.method_25294(x - shadowOffset, y - shadowOffset, x + textWidth + shadowOffset, y + textHeight + shadowOffset, -1873784752);
        }
    }

    private static class_2561 getCPUText() {
        int cpuLoad = (int)OSysInfo.getSystem.getCpuLoad();
        return TextRender.formatColor(cpuLoad);
    }

    private static class_2561 getRamText() {
        if (RuOK.get().GuiEasyRamMode) {
            return TextRender.handleEasyRamMode();
        }
        return TextRender.handleNormalRamMode();
    }

    private static class_2561 handleEasyRamMode() {
        if (RuOK.get().GuiDisplayRamUsage) {
            return TextRender.displayRamUsage().method_27693(" ").method_10852((class_2561)TextRender.formatColor(OSysInfo.getSystem.getMemoryUsagePercentage())).method_27693("%");
        }
        return TextRender.formatColor(OSysInfo.getSystem.getMemoryUsagePercentage()).method_27693("%");
    }

    private static class_2561 handleNormalRamMode() {
        if (RuOK.get().GuiDisplayRamUsage) {
            return TextRender.displayRamUsage().method_27693(" ").method_10852(TextRender.formatRamInfo());
        }
        return TextRender.formatRamInfo();
    }

    private static class_2561 formatRamInfo() {
        class_5250 text = class_2561.method_43473();
        text.method_27693(TextRender.formatByte(OSysInfo.getSystem.getUsedRam()));
        text.method_27693("/");
        text.method_27693(TextRender.formatByte(OSysInfo.getSystem.getMaxRam()));
        return text;
    }

    private static String formatByte(double bytes) {
        if (bytes < 1024.0) {
            return bytes + " B";
        }
        if (bytes < 1048576.0) {
            double kb = bytes / 1024.0;
            return String.format("%.2f KB", kb);
        }
        if (bytes < 1.073741824E9) {
            double mb = bytes / 1048576.0;
            return String.format("%.2f MB", mb);
        }
        double gb = bytes / 1.073741824E9;
        return String.format("%.2f GB", gb);
    }

    public static class_5250 displayRamUsage() {
        class_5250 text = class_2561.method_43473();
        int def = 10;
        int usagePercentage = OSysInfo.getSystem.getMemoryUsagePercentage();
        int numBars = usagePercentage / 10;
        if (numBars > def) {
            numBars = def;
        }
        class_5250 bar = class_2561.method_43473().method_27693("[");
        for (int i = 0; i < def; ++i) {
            if (i < numBars) {
                float ratio = (float)i / (float)def;
                class_2583 style = (double)ratio < 0.3 ? text.method_10866().method_10977(class_124.field_1060) : ((double)ratio < 0.6 ? text.method_10866().method_10977(class_124.field_1054) : ((double)ratio < 0.85 ? text.method_10866().method_10977(class_124.field_1065) : text.method_10866().method_10977(class_124.field_1061)));
                bar.method_10852((class_2561)class_2561.method_43470((String)"|").method_10862(style));
                continue;
            }
            bar.method_27693(" ");
        }
        bar.method_27693("]");
        return bar;
    }

    public static void refInfo() {
        LocalServerInfo.refInfo();
        ++delayText;
        if (++delay > 20) {
            GPU_TEXT = TextRender.formatColor((int)Math.min(mc.method_41734(), 100.0));
            delay = 0;
        }
        if (delayText > 10) {
            RAM_TEXT = TextRender.getRamText();
            CPU_TEXT = TextRender.getCPUText();
            delayText = 0;
        }
        CAMERA_TO_BLOCK = TextRender.getBlockToPlayerPos();
    }

    @NotNull
    private static class_2561 getRXTXData(@NotNull class_310 mc) {
        if (mc.method_1562() != null) {
            class_2535 clientConnection = mc.method_1562().method_48296();
            float rx = clientConnection.method_10762();
            float tx = clientConnection.method_10745();
            return class_2561.method_43469((String)"ruok.options.gui.server,remote.dataio", (Object[])new Object[]{TextRender.formatRXTXColor(Math.round(tx)), TextRender.formatRXTXColor(Math.round(rx))});
        }
        return class_2561.method_43473();
    }

    private static String dis(double I) {
        return String.format("%.1f", I);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    private static class_2561 getRemoteServerPing(@NotNull class_310 mc) {
        class_634 cNet;
        class_640 entry;
        if (mc.field_1724 != null && mc.method_1562() != null && (entry = (cNet = mc.method_1562()).method_2871(mc.field_1724.method_5667())) != null && cNet.method_45734() != null) {
            String mcs = cNet.method_45734().field_3761;
            return class_2561.method_43469((String)"ruok.options.gui.server.remote.info", (Object[])new Object[]{mcs, entry.method_2959()});
        }
        return class_2561.method_43473();
    }

    @NotNull
    private static class_2561 getEntityCount(@NotNull class_638 world) {
        return class_2561.method_43469((String)"ruok.options.gui.entity.count", (Object[])new Object[]{TextRender.formatColor(world.method_18120())});
    }

    private static class_2561 getBlockToPlayerPos() {
        double md = 300.0;
        class_1297 ce = mc.method_1560();
        if (ce != null && TextRender.mc.field_1687 != null) {
            class_239 bH = ce.method_5745(md, 1.0f, false);
            if (bH.method_17783() == class_239.class_240.field_1332) {
                class_243 bP = bH.method_17784();
                class_243 pP = ce.method_19538();
                double distance = Math.sqrt(Math.pow(bP.field_1352 - pP.field_1352, 2.0) + Math.pow(bP.field_1351 - pP.field_1351, 2.0) + Math.pow(bP.field_1350 - pP.field_1350, 2.0));
                return class_2561.method_43469((String)"ruok.options.gui.camera.pos", (Object[])new Object[]{TextRender.dis(bP.field_1352), TextRender.dis(bP.field_1351), TextRender.dis(bP.field_1350), TextRender.dis(distance)});
            }
            return class_2561.method_43469((String)"ruok.options.gui.camera.no_block", (Object[])new Object[]{md});
        }
        return class_2561.method_43473();
    }

    public static int fadeColor(int originalColor, float alphaFactor, float rgbFactor) {
        int alpha = (int)((float)(originalColor >> 24 & 0xFF) * alphaFactor);
        int rgb = originalColor & 0xFFFFFF;
        int newR = (int)((float)(rgb >> 16 & 0xFF) * rgbFactor);
        int newG = (int)((float)(rgb >> 8 & 0xFF) * rgbFactor);
        int newB = (int)((float)(rgb & 0xFF) * rgbFactor);
        return alpha << 24 | newR << 16 | newG << 8 | newB;
    }
}

