/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.sodium;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.gui.base.Base;
import team.teampotato.ruok.gui.base.BaseUtil;
import team.teampotato.ruok.gui.base.OptionManager;
import team.teampotato.ruok.gui.base.RuOKGameOptions;
import team.teampotato.ruok.gui.base.enumText.PerformanceLevel;
import team.teampotato.ruok.gui.sodium.OtherOptions;
import team.teampotato.ruok.gui.sodium.storage.OptionsStorage;

public class Options {
    private static final List<OptionGroup> hudGroup = new ArrayList<OptionGroup>();
    private static final List<OptionGroup> otherGroup = new ArrayList<OptionGroup>();
    private static final List<OptionGroup> mainGroup = new ArrayList<OptionGroup>();
    private static final OptionGroup.Builder mainBuilder = OptionGroup.createBuilder();
    private static final OptionGroup.Builder otherBuilder = OptionGroup.createBuilder();
    private static final OptionGroup.Builder hudBuilder = OptionGroup.createBuilder();
    private static final List<Base<RuOKGameOptions, ?>> adaptedBases = OptionManager.getBinds();

    public static List<OptionGroup> getHudGroup() {
        return hudGroup;
    }

    public static List<OptionGroup> getMainGroup() {
        return mainGroup;
    }

    @Contract(value=" -> new")
    @NotNull
    public static OptionPage getMainGroups() {
        if (Options.getMainGroup().isEmpty()) {
            Options.initMainGroup();
        }
        return new OptionPage((class_2561)class_2561.method_43471((String)"ruok.options.pages.ruok.main"), ImmutableList.copyOf(Options.getMainGroup()));
    }

    @Contract(value=" -> new")
    @NotNull
    public static OptionPage getOtherGroups() {
        if (Options.getOtherGroup().isEmpty()) {
            Options.initOtherGroup();
        }
        return new OptionPage((class_2561)class_2561.method_43471((String)"ruok.options.pages.ruok.other"), ImmutableList.copyOf(Options.getOtherGroup()));
    }

    @Contract(value=" -> new")
    @NotNull
    public static OptionPage getHudGroups() {
        if (Options.getHudGroup().isEmpty()) {
            Options.initHUDGroup();
        }
        return new OptionPage((class_2561)class_2561.method_43471((String)"ruok.options.pages.ruok.hud"), ImmutableList.copyOf(Options.getHudGroup()));
    }

    public static List<OptionGroup> getOtherGroup() {
        return otherGroup;
    }

    public static void initGroup() {
        Options.initMainGroup();
        Options.initOtherGroup();
        Options.initHUDGroup();
    }

    private static void initHUDGroup() {
        Options.processGroup(BaseUtil.Group.HUD, hudBuilder);
        hudBuilder.add(OtherOptions.getHUDConfigScreen());
        Options.getHudGroup().add(hudBuilder.build());
    }

    private static void initMainGroup() {
        Options.processGroup(BaseUtil.Group.MAIN, mainBuilder);
        Options.getMainGroup().add(mainBuilder.build());
    }

    private static void initOtherGroup() {
        Options.processGroup(BaseUtil.Group.OTHER, otherBuilder);
        Options.getOtherGroup().add(otherBuilder.build());
    }

    private static void processGroup(BaseUtil.Group group, OptionGroup.Builder builder) {
        ArrayList baseList = new ArrayList();
        for (Base<RuOKGameOptions, Object> base : adaptedBases) {
            if (base.group != group) continue;
            baseList.add(base);
        }
        for (Base<RuOKGameOptions, Object> base : baseList) {
            if (BaseUtil.isBoolean(base)) {
                Options.processBoolean(base, builder);
            }
            if (BaseUtil.isInteger(base)) {
                Options.processInteger(base, builder);
            }
            if (!BaseUtil.isEnum(base)) continue;
            Options.processEnum(base, builder);
        }
    }

    private static void processBoolean(Base<RuOKGameOptions, Boolean> base, OptionGroup.Builder builder) {
        OptionImpl option = OptionImpl.createBuilder(Boolean.class, (OptionStorage)OptionsStorage.getOptionStorage()).setName((class_2561)class_2561.method_43471((String)(base.key + ".info"))).setTooltip((class_2561)class_2561.method_43471((String)(base.key + ".tooltip")).method_10852((class_2561)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel))).setControl(TickBoxControl::new).setBinding(base.biConsumer, base.function).setImpact(Options.getImpact(base)).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build();
        builder.add((Option)option);
    }

    private static void processInteger(Base<RuOKGameOptions, Integer> base, OptionGroup.Builder builder) {
        OptionImpl option = OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)OptionsStorage.getOptionStorage()).setName((class_2561)class_2561.method_43471((String)(base.key + ".info"))).setTooltip((class_2561)class_2561.method_43471((String)(base.key + ".tooltip")).method_10852((class_2561)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel))).setControl(o -> Options.getIntegerControl(base, (OptionImpl<RuOKGameOptions, Integer>)o)).setBinding(base.biConsumer, base.function).setImpact(Options.getImpact(base)).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build();
        builder.add((Option)option);
    }

    @NotNull
    private static SliderControl getIntegerControl(Base<RuOKGameOptions, Integer> base, OptionImpl<RuOKGameOptions, Integer> optio) {
        return new SliderControl(optio, base.min, base.max, base.interVal, ControlValueFormatter.translateVariable((String)base.format));
    }

    private static void processEnum(@NotNull Base<RuOKGameOptions, ?> base, OptionGroup.Builder builder) {
        Options.addNewEnumOption(base, builder);
    }

    private static <T extends Enum<T>> void addNewEnumOption(Base<RuOKGameOptions, ?> rawBase, OptionGroup.Builder builder) {
        Base<RuOKGameOptions, ?> base = rawBase;
        Class enumClass = base.getEnumClass();
        OptionImpl option = OptionImpl.createBuilder(enumClass, (OptionStorage)OptionsStorage.getOptionStorage()).setName((class_2561)class_2561.method_43471((String)(base.key + ".info"))).setTooltip((class_2561)class_2561.method_43471((String)(base.key + ".tooltip")).method_10852((class_2561)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel))).setControl(o -> new CyclingControl((Option)o, enumClass, base.texts)).setBinding(base.biConsumer, base.function).setImpact(Options.getImpact(base)).build();
        builder.add((Option)option);
    }

    private static OptionImpact getImpact(Base<RuOKGameOptions, ?> base) {
        PerformanceLevel performanceLevel = base.performanceLevel;
        if (performanceLevel.equals(PerformanceLevel.HIGH)) {
            return OptionImpact.HIGH;
        }
        if (performanceLevel.equals(PerformanceLevel.MEDIUM)) {
            return OptionImpact.MEDIUM;
        }
        if (performanceLevel.equals(PerformanceLevel.LOW)) {
            return OptionImpact.LOW;
        }
        return OptionImpact.MEDIUM;
    }
}

