/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util;

import java.util.EnumMap;
import net.minecraft.class_4063;
import net.minecraft.class_4066;
import net.minecraft.class_5365;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.gui.base.enumText.QualityType;
import team.teampotato.ruok.gui.base.enumText.WeatherType;
import team.teampotato.ruok.util.Options;

public class Quality {
    private static final EnumMap<QualityType, QualitySettings> QUALITY_SETTINGS_MAP = new EnumMap(QualityType.class);

    public static void set(@NotNull QualityType mode) {
        QualitySettings settings = QUALITY_SETTINGS_MAP.get(mode);
        Quality.applySettings(settings);
        RuOK.get().qualityModes = mode;
    }

    private static void applySettings(@NotNull QualitySettings settings) {
        Options.setGraphicsMode(settings.graphicsMode);
        Options.setViewDistance(settings.viewDistance);
        Options.setVsync(settings.vsync);
        Options.setParticles(settings.particlesMode);
        Options.setAo(settings.ao);
        Options.setCloudRenderMode(settings.cloudRenderMode);
        Options.setEntityShadows(settings.entityShadows);
        RuOK.get().MaxEntityEntities = settings.maxEntityEntities;
        RuOK.get().EntityDistance = settings.entitiesDistance;
        RuOK.get().RenderWeather = settings.weather;
        RuOK.get().MaxParticleDistance = settings.maxParticleDistance;
    }

    static {
        QUALITY_SETTINGS_MAP.put(QualityType.ULTRA, new QualitySettings(WeatherType.NORMAL, 16, false, class_4066.field_18197, class_5365.field_25429, true, class_4063.field_18164, true, 1024, 512, 512));
        QUALITY_SETTINGS_MAP.put(QualityType.HIGH, new QualitySettings(WeatherType.NORMAL, 12, true, class_4066.field_18199, class_5365.field_25428, true, class_4063.field_18164, true, 512, 256, 256));
        QUALITY_SETTINGS_MAP.put(QualityType.NORMAL, new QualitySettings(WeatherType.NORMAL, 8, true, class_4066.field_18197, class_5365.field_25429, true, class_4063.field_18163, true, 256, 128, 128));
        QUALITY_SETTINGS_MAP.put(QualityType.LOW, new QualitySettings(WeatherType.LOW, 6, true, class_4066.field_18199, class_5365.field_25427, true, class_4063.field_18162, false, 128, 64, 64));
        QUALITY_SETTINGS_MAP.put(QualityType.CRITICAL, new QualitySettings(WeatherType.CLOSE, 2, true, class_4066.field_18199, class_5365.field_25427, false, class_4063.field_18162, false, 64, 32, 32));
    }

    private record QualitySettings(WeatherType weather, int viewDistance, boolean vsync, class_4066 particlesMode, class_5365 graphicsMode, boolean ao, class_4063 cloudRenderMode, boolean entityShadows, int maxEntityEntities, int entitiesDistance, int maxParticleDistance) {
    }
}

