/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.RuOKMod;

public class TaskManager {
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAX_POOL_SIZE = 16;
    private static final int QUEUE_CAPACITY = 1024;
    private static final int KEEP_ALIVE_SECONDS = 60;
    private static final AtomicInteger rejectedTasks = new AtomicInteger(0);
    private static final AtomicInteger threadId = new AtomicInteger(1);
    private static final ThreadLocal<Boolean> IS_RUOK_ASYNC = ThreadLocal.withInitial(() -> false);
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread thread = new Thread(() -> {
            IS_RUOK_ASYNC.set(true);
            try {
                r.run();
            }
            finally {
                IS_RUOK_ASYNC.remove();
            }
        });
        thread.setName("RuOK-Async-" + threadId.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    };
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(2, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), THREAD_FACTORY, (r, executor) -> {
        rejectedTasks.incrementAndGet();
        RuOKMod.LOGGER.warn("Task rejected! Active: {}, QueueSize: {}, PoolSize: {}", new Object[]{executor.getActiveCount(), executor.getQueue().size(), executor.getPoolSize()});
    });
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(() -> {
            IS_RUOK_ASYNC.set(true);
            try {
                r.run();
            }
            finally {
                IS_RUOK_ASYNC.remove();
            }
        });
        thread.setName("RuOK-Scheduler");
        thread.setDaemon(true);
        return thread;
    });
    private static volatile boolean shutdownCalled = false;

    public static CompletableFuture<Void> runAsync(Runnable task) {
        return CompletableFuture.runAsync(TaskManager.wrapSafe(task), EXECUTOR);
    }

    public static <T> CompletableFuture<T> runAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            IS_RUOK_ASYNC.set(true);
            try {
                Object t = supplier.get();
                return t;
            }
            catch (Throwable t) {
                RuOKMod.LOGGER.error("Exception in async task", t);
                throw t;
            }
            finally {
                IS_RUOK_ASYNC.remove();
            }
        }, EXECUTOR);
    }

    public static void runAsyncFast(Runnable task) {
        ForkJoinPool.commonPool().execute(TaskManager.wrapSafe(task));
    }

    public static void runOnMainThread(Runnable task) {
        class_310.method_1551().execute(TaskManager.wrapSafe(task));
    }

    public static CompletableFuture<Void> runOnMainThreadAsync(Runnable task) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TaskManager.runOnMainThread(() -> {
            try {
                task.run();
                future.complete(null);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public static ScheduledFuture<?> runLater(Runnable task, long delay, TimeUnit unit) {
        return SCHEDULER.schedule(TaskManager.wrapSafe(task), delay, unit);
    }

    private static Runnable wrapSafe(Runnable task) {
        return () -> {
            IS_RUOK_ASYNC.set(true);
            try {
                task.run();
            }
            catch (Throwable t) {
                RuOKMod.LOGGER.error("Exception in async task", t);
            }
            finally {
                IS_RUOK_ASYNC.remove();
            }
        };
    }

    public static void autoShutdown() {
        if (shutdownCalled) {
            return;
        }
        shutdownCalled = true;
        RuOKMod.LOGGER.info("Shutting down task executors...");
        EXECUTOR.shutdown();
        SCHEDULER.shutdown();
        try {
            if (!EXECUTOR.awaitTermination(3L, TimeUnit.SECONDS)) {
                EXECUTOR.shutdownNow();
            }
            if (!SCHEDULER.awaitTermination(3L, TimeUnit.SECONDS)) {
                SCHEDULER.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            EXECUTOR.shutdownNow();
            SCHEDULER.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static int getQueueSize() {
        return EXECUTOR.getQueue().size();
    }

    public static int getActiveThreads() {
        return EXECUTOR.getActiveCount();
    }

    public static int getMaxThreads() {
        return EXECUTOR.getMaximumPoolSize();
    }

    public static int getCoreThreads() {
        return EXECUTOR.getCorePoolSize();
    }

    public static long getCompletedTasks() {
        return EXECUTOR.getCompletedTaskCount();
    }

    public static long getTotalTasks() {
        return EXECUTOR.getTaskCount();
    }

    @NotNull
    public static class_2561 getDebugInfo() {
        return class_2561.method_43469((String)"ruok.quality.task.debug.pool", (Object[])new Object[]{TaskManager.getQueueSize(), TaskManager.getActiveThreads(), TaskManager.getCoreThreads(), TaskManager.getMaxThreads(), TaskManager.getTotalTasks(), TaskManager.getCompletedTasks(), rejectedTasks.get()});
    }

    public static void assertAsyncThread(@NotNull String context) {
        if (!IS_RUOK_ASYNC.get().booleanValue()) {
            RuOKMod.LOGGER.warn("\u26a0 [{}] was called from non-RuOK async thread: {}", (Object)context, (Object)Thread.currentThread().getName());
        }
    }

    public static ThreadPoolExecutor getAsyncExecutor() {
        return EXECUTOR;
    }
}

