/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.entity.EntityUtils;

public class EntityCullRender {
    private static final HashSet<class_1299<?>> blackEntityListCache = new HashSet();
    private static final HashSet<class_1299<?>> whiteEntityListCache = new HashSet();
    private static HashSet<class_1299<?>> blackTagEntityListCache = new HashSet();
    private static HashSet<class_1299<?>> whiteTagEntityListCache = new HashSet();
    private static final class_310 mc = class_310.method_1551();

    private static void initConfigList() {
        Optional<class_1299<?>> entityTypeOpt;
        List<String> blackConfig = RuOK.get().blackListedEntities;
        List<String> whiteConfig = RuOK.get().whiteListedEntities;
        for (String bc : blackConfig) {
            entityTypeOpt = EntityCullRender.entityTypeGet(bc);
            entityTypeOpt.ifPresent(blackEntityListCache::add);
        }
        for (String wc : whiteConfig) {
            entityTypeOpt = EntityCullRender.entityTypeGet(wc);
            entityTypeOpt.ifPresent(whiteEntityListCache::add);
        }
        blackTagEntityListCache = EntityCullRender.getTagEntity(RuOK.get().BlackTagListEntity);
        whiteTagEntityListCache = EntityCullRender.getTagEntity(RuOK.get().WhiteTagListEntity);
    }

    public static Optional<class_1299<?>> entityTypeGet(String id) {
        return class_7923.field_41177.method_17966(class_2960.method_12829((String)id));
    }

    public static HashSet<class_1299<?>> getTagEntity(List<String> list) {
        HashSet entityTypes = new HashSet();
        for (String s : list) {
            class_6862 entity = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960(s));
            class_7923.field_41177.forEach(type -> {
                if (type.method_20210(entity)) {
                    entityTypes.add((class_1299<?>)type);
                }
            });
        }
        return entityTypes;
    }

    public static void reloadList() {
        blackEntityListCache.clear();
        whiteEntityListCache.clear();
        blackTagEntityListCache.clear();
        whiteTagEntityListCache.clear();
        EntityCullRender.initConfigList();
    }

    public static boolean isBlacklisted(@NotNull class_1297 entity) {
        return blackEntityListCache.contains(entity.method_5864()) || blackTagEntityListCache.contains(entity.method_5864());
    }

    public static boolean isWhitelisted(@NotNull class_1297 entity) {
        return whiteEntityListCache.contains(entity.method_5864()) || whiteTagEntityListCache.contains(entity.method_5864());
    }

    public static boolean shouldCull(class_1297 entity, double maxDistance) {
        double maxDistSq;
        if (EntityCullRender.mc.field_1687 == null || EntityCullRender.mc.field_1724 == null || entity == EntityCullRender.mc.field_1724) {
            return false;
        }
        if (EntityCullRender.isBlacklisted(entity)) {
            return true;
        }
        double distSq = entity.method_5858((class_1297)EntityCullRender.mc.field_1724);
        return distSq > (maxDistSq = maxDistance * maxDistance);
    }

    public static boolean isBossEntity(@NotNull class_1297 entity) {
        return EntityUtils.BossTags.isCachedBoss(entity);
    }

    static {
        EntityCullRender.initConfigList();
    }
}

