/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.entity.EntityCullRender;
import team.teampotato.ruok.util.hook.HookDispatcher;
import team.teampotato.ruok.util.render.CameraUtil;

public class EntityUtils {
    private static volatile List<class_1297> entities = Collections.emptyList();

    public static void refViewEntity() {
        entities = EntityUtils.getEntitiesInView(RuOK.get().EntityDistance, RuOK.get().MaxEntityEntities);
    }

    @NotNull
    public static @UnmodifiableView List<class_1297> getVisibleEntities() {
        return entities;
    }

    public static List<class_1297> getEntitiesInView(double maxDistance, int maxEntities) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (camera == null || client.field_1687 == null) {
            return Collections.emptyList();
        }
        double maxDistSq = maxDistance * maxDistance;
        double minDistSq = RuOK.get().MinDistance * RuOK.get().MinDistance;
        double fovDeg = CameraUtil.getSafeCullFov();
        double padDeg = 8.0;
        double aabbPad = 0.75;
        class_243 camPos = camera.method_19326();
        class_243 camLook = CameraUtil.getCameraLookVector();
        ArrayList<class_1297> important = new ArrayList<class_1297>();
        ArrayList<class_1297> normal = new ArrayList<class_1297>();
        for (class_1297 e2 : client.field_1687.method_18112()) {
            if (e2 == client.field_1724 || BossTags.isCachedBoss(e2) || EntityCullRender.isWhitelisted(e2) || e2.method_5858((class_1297)client.field_1724) <= minDistSq) {
                important.add(e2);
                continue;
            }
            normal.add(e2);
        }
        List<class_1297> culled = normal.stream().filter(e -> e.method_5858((class_1297)client.field_1724) <= maxDistSq).filter(e -> !EntityCullRender.isBlacklisted(e)).filter(e -> EntityUtils.isLooselyInView(camPos, camLook, e, fovDeg, 8.0, 0.75)).sorted(Comparator.comparingDouble(e -> e.method_5858((class_1297)client.field_1724))).limit(Math.max(0, maxEntities - important.size())).toList();
        ArrayList<class_1297> out = new ArrayList<class_1297>(important);
        out.addAll(culled);
        return List.copyOf(out);
    }

    private static boolean isLooselyInView(class_243 camPos, class_243 camLook, class_1297 e, double fovDeg, double padDeg, double aabbPad) {
        double half = Math.toRadians((fovDeg + padDeg) * 0.5);
        double cosThreshold = Math.cos(half);
        if (EntityUtils.isDirWithinCone(camPos, camLook, e.method_5829().method_1005(), cosThreshold)) {
            return true;
        }
        class_238 box = e.method_5829().method_1014(aabbPad);
        double[] xs = new double[]{box.field_1323, box.field_1320};
        double[] ys = new double[]{box.field_1322, box.field_1325};
        double[] zs = new double[]{box.field_1321, box.field_1324};
        for (double x : xs) {
            for (double y : ys) {
                for (double z : zs) {
                    if (!EntityUtils.isDirWithinCone(camPos, camLook, new class_243(x, y, z), cosThreshold)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isDirWithinCone(class_243 camPos, class_243 camLook, class_243 target, double cosThreshold) {
        class_243 v = target.method_1020(camPos);
        double len = v.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        return camLook.method_1026(v = v.method_1021(1.0 / len)) >= cosThreshold;
    }

    public static boolean shouldCull(class_1297 entity) {
        return !EntityUtils.getVisibleEntities().contains(entity);
    }

    @Contract(value=" -> new")
    @NotNull
    public static class_2561 getDebugInfo() {
        return class_2561.method_43469((String)"ruok.quality.entity.cull.debug", (Object[])new Object[]{class_310.method_1551().field_1687.method_18120(), EntityUtils.getVisibleEntities().size(), class_310.method_1551().field_1687.method_18120() - EntityUtils.getVisibleEntities().size()});
    }

    public static final class BossTags {
        public static final class_6862<class_1299<?>> VANILLA = BossTags.of("minecraft:bosses");
        public static final class_6862<class_1299<?>> FORGE = BossTags.of("forge:bosses");
        public static final class_6862<class_1299<?>> COMMON = BossTags.of("c:bosses");
        private static final Set<class_1299<?>> BOSS_CACHE = new HashSet();
        private static boolean initialized = false;

        private static class_6862<class_1299<?>> of(String id) {
            return class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960(id));
        }

        private static void initBossCache() {
            if (initialized) {
                return;
            }
            class_7923.field_41177.forEach(type -> {
                if (type.method_20210(VANILLA) || type.method_20210(FORGE) || type.method_20210(COMMON)) {
                    BOSS_CACHE.add((class_1299<?>)type);
                }
            });
            initialized = true;
        }

        public static boolean isBoss(class_1297 entity) {
            return entity.method_5864().method_20210(VANILLA) || entity.method_5864().method_20210(FORGE) || entity.method_5864().method_20210(COMMON);
        }

        public static boolean isCachedBoss(class_1297 entity) {
            return BOSS_CACHE.contains(entity.method_5864());
        }

        public static Set<class_1299<?>> getBossSet() {
            return BOSS_CACHE;
        }

        static {
            HookDispatcher.register(HookDispatcher.HookType.TICK, BossTags::initBossCache);
        }
    }
}

