/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.particle;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6734;
import net.minecraft.class_682;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_727;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.mixin.minecraft.ParticleAccessor;
import team.teampotato.ruok.util.render.CameraUtil;

public class ParticleRender {
    private static final Set<class_2396<?>> blackList = new HashSet();
    private static final Set<class_2396<?>> whiteList = new HashSet();
    private static final class_310 mc = class_310.method_1551();

    public static void reloadLists() {
        blackList.clear();
        whiteList.clear();
        for (String id : RuOK.get().BlackListedParticle) {
            ParticleRender.parseType(id).ifPresent(blackList::add);
        }
        for (String id : RuOK.get().WhiteListedParticle) {
            ParticleRender.parseType(id).ifPresent(whiteList::add);
        }
    }

    private static Optional<class_2396<?>> parseType(String id) {
        return class_7923.field_41180.method_17966(class_2960.method_12829((String)id));
    }

    public static <T extends class_2394> void onAddParticle(class_702 manager, class_703 particle, T effect, double x, double y, double z) {
        if (ParticleRender.shouldRender(effect)) {
            manager.method_3058(particle);
        } else {
            particle.method_3085();
        }
    }

    public static void onAddParticleRaw(class_703 particle, CallbackInfo ci) {
        boolean sp = ParticleRender.shouldRawRender(particle);
        if (RuOK.get().ParticlePerformance) {
            return;
        }
        if (!sp) {
            ci.cancel();
        }
    }

    public static boolean shouldRawRender(class_703 particle) {
        double maxDistSq;
        if (ParticleRender.isBlockParticle(particle) && !RuOK.get().BlockBreakParticle) {
            return false;
        }
        ParticleAccessor accessor = (ParticleAccessor)particle;
        class_243 camPos = ParticleRender.mc.field_1773.method_19418().method_19326();
        class_243 camLook = CameraUtil.getCameraLookVector();
        double fov = CameraUtil.getSafeCullFov();
        if (!ParticleRender.isParticleLooselyInView(camPos, camLook, accessor.getX(), accessor.getY(), accessor.getZ(), fov, 20.0, 0.1)) {
            return false;
        }
        double distSq = camPos.method_1028(accessor.getX(), accessor.getY(), accessor.getZ());
        return !(distSq > (maxDistSq = Math.pow(RuOK.get().MaxParticleDistance, 2.0)));
    }

    private static boolean shouldRender(@NotNull class_2394 effect) {
        class_2396 type = effect.method_10295();
        if (whiteList.contains(type)) {
            return true;
        }
        return !blackList.contains(type);
    }

    private static boolean isBlockParticle(class_703 p) {
        return p instanceof class_727 || p instanceof class_682 || p instanceof class_6734;
    }

    private static boolean isParticleLooselyInView(class_243 camPos, class_243 camLook, double px, double py, double pz, double fovDeg, double padDeg, double aabbPad) {
        double half = Math.toRadians((fovDeg + padDeg) * 0.5);
        double cosThreshold = Math.cos(half);
        if (ParticleRender.isDirWithinCone(camPos, camLook, new class_243(px, py, pz), cosThreshold)) {
            return true;
        }
        double s = aabbPad;
        double[] xs = new double[]{px - s, px + s};
        double[] ys = new double[]{py - s, py + s};
        double[] zs = new double[]{pz - s, pz + s};
        for (double x : xs) {
            for (double y : ys) {
                for (double z : zs) {
                    if (!ParticleRender.isDirWithinCone(camPos, camLook, new class_243(x, y, z), cosThreshold)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isDirWithinCone(class_243 camPos, class_243 camLook, class_243 target, double cosThreshold) {
        class_243 v = target.method_1020(camPos);
        double len = v.method_1033();
        if (len < 1.0E-6) {
            return true;
        }
        return camLook.method_1026(v = v.method_1021(1.0 / len)) >= cosThreshold;
    }

    static {
        ParticleRender.reloadLists();
    }
}

