/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.render;

import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import team.teampotato.ruok.config.RuOK;

public class ItemRender {
    public static void render(class_1542 item, class_4587 matrices, class_4597 vertexConsumers, int light, Quaternionf quaternion) {
        if (!RuOK.get().RenderDisplayItem) {
            return;
        }
        ItemRender.getTotalCountForDisplay(item).ifPresent(text -> {
            if (item.method_6983().method_7947() != 0) {
                float itemHeight = item.method_17682() + 0.5f;
                matrices.method_22903();
                matrices.method_22904(0.0, (double)itemHeight, 0.0);
                matrices.method_22907(quaternion);
                matrices.method_22905(-0.025f, -0.025f, 0.025f);
                Matrix4f matrix4f = matrices.method_23760().method_23761();
                class_327 textRenderer = class_310.method_1551().field_1772;
                int textColor = 6;
                int backgroundColor = 0;
                textRenderer.method_30882((class_2561)text, (float)(-textRenderer.method_27525((class_5348)text)) / 2.0f, 0.0f, textColor, false, matrix4f, vertexConsumers, class_327.class_6415.field_33993, backgroundColor, light);
                matrices.method_22909();
            }
        });
    }

    private static Optional<class_5250> getTotalCountForDisplay(@NotNull class_1542 entity) {
        class_1799 stack = entity.method_6983();
        int count = stack.method_7947();
        class_5251 color = ItemRender.getGradientColor(count);
        class_5250 displayText = stack.method_7964().method_27661().method_27694(style -> style.method_27703(color)).method_27693(" " + count + "x");
        return count > stack.method_7914() || RuOK.get().isAlwaysShowItemCount ? Optional.of(displayText) : Optional.empty();
    }

    private static class_5251 getGradientColor(int count) {
        int min = 1;
        int max = 64;
        int clamped = Math.max(min, Math.min(count, max));
        float t = (float)(clamped - min) / (float)(max - min);
        float h = 120.0f * (1.0f - t);
        float s = 1.0f;
        float l = 0.5f;
        int rgb = ItemRender.hslToRgb(h, s, l);
        return class_5251.method_27717((int)rgb);
    }

    private static int hslToRgb(float h, float s, float l) {
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (h < 60.0f) {
            r1 = c;
            g1 = x;
        } else if (h < 120.0f) {
            r1 = x;
            g1 = c;
        } else if (h < 180.0f) {
            g1 = c;
            b1 = x;
        } else if (h < 240.0f) {
            g1 = x;
            b1 = c;
        } else if (h < 300.0f) {
            r1 = x;
            b1 = c;
        } else {
            r1 = c;
            b1 = x;
        }
        int r = Math.round((r1 + m) * 255.0f);
        int g = Math.round((g1 + m) * 255.0f);
        int b = Math.round((b1 + m) * 255.0f);
        return r << 16 | g << 8 | b;
    }
}

