/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.BorderConfig;
import com.procurer.ExpansionMode;
import com.procurer.ExpansiveBorder;
import com.procurer.TriggerMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class BorderCommand
implements CommandExecutor,
TabCompleter {
    private final ExpansiveBorder plugin;
    private final BorderConfig config;

    public BorderCommand(ExpansiveBorder plugin, BorderConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("expansiveborder.admin")) {
            sender.sendMessage((Component)Component.text((String)"You don't have permission to use this command!", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "start": {
                return this.handleStart(sender);
            }
            case "stop": {
                return this.handleStop(sender);
            }
            case "expansion": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /eborder expansion [block|chunk]", (TextColor)NamedTextColor.RED));
                    return true;
                }
                return this.handleExpansion(sender, args[1]);
            }
            case "mode": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /eborder mode [advancements|levels|both]", (TextColor)NamedTextColor.RED));
                    return true;
                }
                return this.handleMode(sender, args[1]);
            }
            case "multiplier": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /eborder multiplier <amount>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                return this.handleMultiplier(sender, args[1]);
            }
            case "status": {
                return this.handleStatus(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleStart(CommandSender sender) {
        if (this.plugin.isGameActive()) {
            sender.sendMessage((Component)Component.text((String)"Game is already active!", (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        this.plugin.startGame();
        sender.sendMessage((Component)Component.text((String)"Game started! World border has been reset.", (TextColor)NamedTextColor.GREEN));
        Bukkit.broadcast((Component)Component.text((String)"ExpansiveBorder game has started!", (TextColor)NamedTextColor.GOLD));
        return true;
    }

    private boolean handleStop(CommandSender sender) {
        if (!this.plugin.isGameActive()) {
            sender.sendMessage((Component)Component.text((String)"Game is not active!", (TextColor)NamedTextColor.YELLOW));
            return true;
        }
        this.plugin.stopGame();
        sender.sendMessage((Component)Component.text((String)"Game stopped!", (TextColor)NamedTextColor.GREEN));
        Bukkit.broadcast((Component)Component.text((String)"ExpansiveBorder game has stopped!", (TextColor)NamedTextColor.GOLD));
        return true;
    }

    private boolean handleExpansion(CommandSender sender, String mode) {
        switch (mode.toLowerCase()) {
            case "block": {
                this.config.setExpansionMode(ExpansionMode.BLOCK);
                sender.sendMessage((Component)Component.text((String)"Expansion mode set to: BLOCK", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "chunk": {
                this.config.setExpansionMode(ExpansionMode.CHUNK);
                sender.sendMessage((Component)Component.text((String)"Expansion mode set to: CHUNK", (TextColor)NamedTextColor.GREEN));
                return true;
            }
        }
        sender.sendMessage((Component)Component.text((String)"Invalid expansion mode! Use: block or chunk", (TextColor)NamedTextColor.RED));
        return true;
    }

    private boolean handleMode(CommandSender sender, String mode) {
        switch (mode.toLowerCase()) {
            case "advancements": {
                this.config.setTriggerMode(TriggerMode.ADVANCEMENTS);
                sender.sendMessage((Component)Component.text((String)"Trigger mode set to: ADVANCEMENTS", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "levels": {
                this.config.setTriggerMode(TriggerMode.LEVELS);
                sender.sendMessage((Component)Component.text((String)"Trigger mode set to: LEVELS", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "both": {
                this.config.setTriggerMode(TriggerMode.BOTH);
                sender.sendMessage((Component)Component.text((String)"Trigger mode set to: BOTH", (TextColor)NamedTextColor.GREEN));
                return true;
            }
        }
        sender.sendMessage((Component)Component.text((String)"Invalid trigger mode! Use: advancements, levels, or both", (TextColor)NamedTextColor.RED));
        return true;
    }

    private boolean handleMultiplier(CommandSender sender, String multiplierStr) {
        try {
            int multiplier = Integer.parseInt(multiplierStr);
            if (multiplier < 1) {
                sender.sendMessage((Component)Component.text((String)"Multiplier must be at least 1!", (TextColor)NamedTextColor.RED));
                return true;
            }
            this.config.setMultiplier(multiplier);
            sender.sendMessage((Component)Component.text((String)("Multiplier set to: " + multiplier), (TextColor)NamedTextColor.GREEN));
            return true;
        }
        catch (NumberFormatException e) {
            sender.sendMessage((Component)Component.text((String)"Invalid number!", (TextColor)NamedTextColor.RED));
            return true;
        }
    }

    private boolean handleStatus(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"=== ExpansiveBorder Status ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"Game Active: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)(this.plugin.isGameActive() ? "Yes" : "No"), (TextColor)(this.plugin.isGameActive() ? NamedTextColor.GREEN : NamedTextColor.RED))));
        sender.sendMessage(Component.text((String)"Expansion Mode: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)this.config.getExpansionMode().name(), (TextColor)NamedTextColor.AQUA)));
        sender.sendMessage(Component.text((String)"Trigger Mode: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)this.config.getTriggerMode().name(), (TextColor)NamedTextColor.AQUA)));
        sender.sendMessage(Component.text((String)"Multiplier: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)String.valueOf(this.config.getMultiplier()), (TextColor)NamedTextColor.AQUA)));
        WorldBorder border = ((World)Bukkit.getWorlds().get(0)).getWorldBorder();
        sender.sendMessage(Component.text((String)"Current Border Size: ", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)(border.getSize() + " blocks"), (TextColor)NamedTextColor.AQUA)));
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"=== ExpansiveBorder Commands ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text((String)"/eborder start", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Start the game", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/eborder stop", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Stop the game", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/eborder expansion [block|chunk]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Set expansion mode", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/eborder mode [advancements|levels|both]", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Set trigger mode", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/eborder multiplier <amount>", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Set expansion multiplier", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text((String)"/eborder status", (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" - Show current status", (TextColor)NamedTextColor.GRAY)));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("start", "stop", "expansion", "mode", "multiplier", "status"));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("expansion")) {
            completions.addAll(Arrays.asList("block", "chunk"));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("mode")) {
            completions.addAll(Arrays.asList("advancements", "levels", "both"));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("multiplier")) {
            completions.addAll(Arrays.asList("1", "2", "4", "8", "16"));
        }
        String partial = args[args.length - 1].toLowerCase();
        completions.removeIf(s -> !s.toLowerCase().startsWith(partial));
        return completions;
    }
}

