/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.ExpansionMode;
import com.procurer.ExpansiveBorder;
import com.procurer.TriggerMode;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BorderConfig {
    private final ExpansiveBorder plugin;
    private File configFile;
    private FileConfiguration config;
    private ExpansionMode expansionMode = ExpansionMode.BLOCK;
    private TriggerMode triggerMode = TriggerMode.BOTH;
    private int multiplier = 1;

    public BorderConfig(ExpansiveBorder plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.configFile = new File(this.plugin.getDataFolder(), "border-config.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create border-config.yml!");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.expansionMode = ExpansionMode.valueOf(this.config.getString("expansion-mode", "BLOCK"));
        this.triggerMode = TriggerMode.valueOf(this.config.getString("trigger-mode", "BOTH"));
        this.multiplier = this.config.getInt("multiplier", 1);
    }

    public void saveConfig() {
        try {
            this.config.set("expansion-mode", (Object)this.expansionMode.name());
            this.config.set("trigger-mode", (Object)this.triggerMode.name());
            this.config.set("multiplier", (Object)this.multiplier);
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save border-config.yml!");
            e.printStackTrace();
        }
    }

    public ExpansionMode getExpansionMode() {
        return this.expansionMode;
    }

    public void setExpansionMode(ExpansionMode mode) {
        this.expansionMode = mode;
        this.saveConfig();
    }

    public TriggerMode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(TriggerMode mode) {
        this.triggerMode = mode;
        this.saveConfig();
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = Math.max(1, multiplier);
        this.saveConfig();
    }

    public double getExpansionAmount() {
        if (this.expansionMode == ExpansionMode.BLOCK) {
            return this.multiplier;
        }
        return (double)this.multiplier * 16.0;
    }
}

