/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.BorderConfig;
import com.procurer.ExpansionMode;
import com.procurer.ExpansiveBorder;
import com.procurer.TriggerMode;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;

public class BorderListener
implements Listener {
    private final ExpansiveBorder plugin;
    private final BorderConfig config;

    public BorderListener(ExpansiveBorder plugin, BorderConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    @EventHandler
    public void onPlayerLevelUp(PlayerLevelChangeEvent event) {
        if (!this.plugin.isGameActive()) {
            return;
        }
        TriggerMode triggerMode = this.config.getTriggerMode();
        if (triggerMode != TriggerMode.LEVELS && triggerMode != TriggerMode.BOTH) {
            return;
        }
        if (event.getNewLevel() > event.getOldLevel()) {
            Player player = event.getPlayer();
            this.expandBorder(player, "reaching level " + event.getNewLevel());
        }
    }

    @EventHandler
    public void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (!this.plugin.isGameActive()) {
            return;
        }
        TriggerMode triggerMode = this.config.getTriggerMode();
        if (triggerMode != TriggerMode.ADVANCEMENTS && triggerMode != TriggerMode.BOTH) {
            return;
        }
        String advancementKey = event.getAdvancement().getKey().getKey();
        if (advancementKey.startsWith("recipes/")) {
            return;
        }
        Player player = event.getPlayer();
        String advancementName = this.getAdvancementName(event.getAdvancement());
        this.expandBorder(player, "completing: " + advancementName);
    }

    private void expandBorder(Player triggerPlayer, String reason) {
        Object unit;
        World world = (World)Bukkit.getWorlds().get(0);
        WorldBorder border = world.getWorldBorder();
        double expansionAmount = this.config.getExpansionAmount();
        double newSize = border.getSize() + expansionAmount;
        border.setSize(newSize);
        Object object = unit = this.config.getExpansionMode() == ExpansionMode.BLOCK ? "block" : "chunk";
        if (this.config.getMultiplier() != 1) {
            unit = (String)unit + "s";
        }
        Component message = ((TextComponent)((TextComponent)Component.text((String)triggerPlayer.getName(), (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)" expanded the border by ", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)(this.config.getMultiplier() + " " + (String)unit), (TextColor)NamedTextColor.AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)(" by " + reason), (TextColor)NamedTextColor.YELLOW));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendActionBar(message);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
            this.spawnParticlesAroundPlayer(player);
        }
        this.plugin.getLogger().info(triggerPlayer.getName() + " expanded the border to " + newSize + " blocks");
    }

    private void spawnParticlesAroundPlayer(Player player) {
        Location loc = player.getLocation();
        World world = loc.getWorld();
        for (int i = 0; i < 36; ++i) {
            double angle = Math.PI * 2 * (double)i / 36.0;
            double x = loc.getX() + 2.0 * Math.cos(angle);
            double z = loc.getZ() + 2.0 * Math.sin(angle);
            double y = loc.getY() + 1.0;
            Location particleLoc = new Location(world, x, y, z);
            world.spawnParticle(Particle.TOTEM_OF_UNDYING, particleLoc, 3, 0.1, 0.1, 0.1, 0.05);
            world.spawnParticle(Particle.END_ROD, particleLoc, 1, 0.0, 0.5, 0.0, 0.05);
        }
        world.spawnParticle(Particle.FIREWORK, loc.clone().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.1);
    }

    private String getAdvancementName(Advancement advancement) {
        try {
            if (advancement.getDisplay() != null && advancement.getDisplay().title() != null) {
                return PlainTextComponentSerializer.plainText().serialize(advancement.getDisplay().title());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String key = advancement.getKey().getKey();
        return key.replace("_", " ").replace("/", " > ");
    }
}

