/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.BorderCommand;
import com.procurer.BorderConfig;
import com.procurer.BorderListener;
import com.procurer.ExpansionMode;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ExpansiveBorder
extends JavaPlugin {
    private BorderConfig borderConfig;
    private BorderListener borderListener;
    private File configFile;
    private FileConfiguration config;
    private boolean gameActive = false;
    private double previousBorderSize = 0.0;

    public void onEnable() {
        this.getLogger().info("ExpansiveBorder plugin enabled!");
        this.loadConfiguration();
        this.borderConfig = new BorderConfig(this);
        this.borderListener = new BorderListener(this, this.borderConfig);
        this.getServer().getPluginManager().registerEvents((Listener)this.borderListener, (Plugin)this);
        BorderCommand borderCommand = new BorderCommand(this, this.borderConfig);
        this.getCommand("eborder").setExecutor((CommandExecutor)borderCommand);
        this.getCommand("eborder").setTabCompleter((TabCompleter)borderCommand);
    }

    public void onDisable() {
        this.getLogger().info("ExpansiveBorder plugin disabled!");
        this.saveConfiguration();
    }

    private void loadConfiguration() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create config.yml!");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.gameActive = this.config.getBoolean("game-active", false);
        this.previousBorderSize = this.config.getDouble("previous-border-size", 5.9999968E7);
    }

    public void saveConfiguration() {
        try {
            this.config.set("game-active", (Object)this.gameActive);
            this.config.set("previous-border-size", (Object)this.previousBorderSize);
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save config.yml!");
            e.printStackTrace();
        }
    }

    public void startGame() {
        if (this.gameActive) {
            return;
        }
        this.gameActive = true;
        World world = (World)Bukkit.getWorlds().get(0);
        WorldBorder border = world.getWorldBorder();
        this.previousBorderSize = border.getSize();
        double initialSize = this.borderConfig.getExpansionMode() == ExpansionMode.BLOCK ? 1.0 : 16.0;
        Location centerLocation = world.getSpawnLocation();
        border.setCenter(centerLocation);
        border.setSize(initialSize);
        Location safeLocation = this.findSafeSpawnLocation(world, centerLocation);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.teleport(safeLocation);
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            this.spawnStartParticles(player);
        }
        this.saveConfiguration();
        this.getLogger().info("Game started! World border set to " + initialSize + " blocks.");
    }

    public void stopGame() {
        if (!this.gameActive) {
            return;
        }
        this.gameActive = false;
        World world = (World)Bukkit.getWorlds().get(0);
        WorldBorder border = world.getWorldBorder();
        border.setSize(this.previousBorderSize);
        this.saveConfiguration();
        this.getLogger().info("Game stopped! Border restored to " + this.previousBorderSize + " blocks.");
    }

    public boolean isGameActive() {
        return this.gameActive;
    }

    public BorderConfig getBorderConfig() {
        return this.borderConfig;
    }

    private Location findSafeSpawnLocation(World world, Location center) {
        Location safeLoc = center.clone();
        int highestY = world.getHighestBlockYAt(safeLoc);
        safeLoc.setY((double)highestY);
        Block block = safeLoc.getBlock();
        if (highestY < 60) {
            safeLoc.setY(70.0);
        } else if (highestY > 150) {
            safeLoc.setY(70.0);
        }
        safeLoc.add(0.0, 1.0, 0.0);
        return safeLoc;
    }

    private void spawnStartParticles(Player player) {
        Location loc = player.getLocation();
        World world = loc.getWorld();
        for (int i = 0; i < 50; ++i) {
            double angle = Math.PI * 2 * (double)i / 50.0;
            double radius = 2.0;
            double x = loc.getX() + radius * Math.cos(angle);
            double z = loc.getZ() + radius * Math.sin(angle);
            double y = loc.getY() + (double)i * 0.1;
            Location particleLoc = new Location(world, x, y, z);
            world.spawnParticle(Particle.ENCHANT, particleLoc, 3, 0.0, 0.0, 0.0, 1.0);
            world.spawnParticle(Particle.HAPPY_VILLAGER, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.spawnParticle(Particle.EXPLOSION_EMITTER, loc.clone().add(0.0, 1.0, 0.0), 3, 0.5, 0.5, 0.5, 0.0);
        world.spawnParticle(Particle.FIREWORK, loc.clone().add(0.0, 2.0, 0.0), 30, 0.5, 1.0, 0.5, 0.1);
        world.spawnParticle(Particle.TOTEM_OF_UNDYING, loc.clone().add(0.0, 1.5, 0.0), 40, 0.5, 0.5, 0.5, 0.1);
        world.spawnParticle(Particle.WITCH, loc, 20, 1.0, 1.0, 1.0, 0.05);
    }
}

