/*
 * Decompiled with CFR 0.152.
 */
package box.com.speedbuilderhelper;

import box.com.speedbuilderhelper.PlayerUtils;
import box.com.speedbuilderhelper.SpeedBuilderHelper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class CMDS
extends CommandBase {
    private static final File TIMES_FILE = new File(SpeedBuilderHelper.Directory, "speedbuilder_times.json");
    private static final Gson GSON = new Gson();

    public String func_71517_b() {
        return "speedbuilders";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/speedbuilders";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("sb", "speedbuilders");
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            PlayerUtils.sendLine();
            PlayerUtils.sendMessageWithPing("\u00a7eSpeed-Builder Helper Commands");
            PlayerUtils.sendMessage(" \u00a73/speedbuilders debug\u00a77: enables / disables debugging");
            PlayerUtils.sendMessage(" \u00a73/speedbuilders toggle\u00a77: enables / disables speed-builder helper");
            PlayerUtils.sendMessage(" \u00a73/speedbuilders setname\u00a77: sets your username to what you input");
            PlayerUtils.sendMessage(" \u00a73/speedbuilders times\u00a77: shows your best times sorted by speed");
            PlayerUtils.sendMessage(" \u00a73/speedbuilders showtime\u00a77: shows your best time for the theme you are currently playing");
            PlayerUtils.sendMessage(" \u00a73/speedbuilders overview\u00a77: shows all new best times achieved this session");
            PlayerUtils.sendMessage(" \u00a73/speedbuilders reset\u00a77: clears the session best times list");
            PlayerUtils.sendLine();
        } else if (args[0].equalsIgnoreCase("debug")) {
            SpeedBuilderHelper.Debug = !SpeedBuilderHelper.Debug;
            PlayerUtils.sendMessageWithPing("&eDebug has been " + (SpeedBuilderHelper.Debug ? "&aenabled" : "&cdisabled") + "&e.");
            SpeedBuilderHelper.saveConfig();
        } else if (args[0].equalsIgnoreCase("toggle")) {
            SpeedBuilderHelper.Activated = !SpeedBuilderHelper.Activated;
            PlayerUtils.sendMessageWithPing("&espeed-builder helper has been " + (SpeedBuilderHelper.Activated ? "&aenabled" : "&cdisabled") + "&e.");
            SpeedBuilderHelper.saveConfig();
        } else if (args[0].equalsIgnoreCase("showtime")) {
            SpeedBuilderHelper.StartingMessage = !SpeedBuilderHelper.StartingMessage;
            PlayerUtils.sendMessageWithPing("&eShow Times has been " + (SpeedBuilderHelper.StartingMessage ? "&aenabled" : "&cdisabled") + "&e.");
            SpeedBuilderHelper.saveConfig();
        } else if (args[0].equalsIgnoreCase("setname")) {
            if (args.length < 2) {
                PlayerUtils.sendMessageWithPing("&ePlease enter a username!");
                return;
            }
            SpeedBuilderHelper.playerName = args[1];
            PlayerUtils.sendMessageWithPing("&eSet name to &3" + args[1]);
            SpeedBuilderHelper.saveConfig();
        } else if (args[0].equalsIgnoreCase("times")) {
            try {
                if (!TIMES_FILE.exists()) {
                    PlayerUtils.sendError("\u00a7cNo times recorded yet!");
                    return;
                }
                JsonObject json = (JsonObject)GSON.fromJson((Reader)new FileReader(TIMES_FILE), JsonObject.class);
                JsonArray themesArray = json.getAsJsonArray("themes");
                ArrayList times = new ArrayList();
                String targetTheme = args.length > 1 ? args[1].toLowerCase() : "";
                for (JsonElement jsonElement : themesArray) {
                    JsonObject record = jsonElement.getAsJsonObject();
                    if (!targetTheme.isEmpty() && !record.get("theme").getAsString().toLowerCase().contains(targetTheme)) continue;
                    HashMap<String, Object> timeRecord = new HashMap<String, Object>();
                    timeRecord.put("theme", record.get("theme").getAsString());
                    timeRecord.put("difficulty", record.get("difficulty").getAsString());
                    timeRecord.put("bestTime", record.get("bestTime").getAsDouble());
                    times.add(timeRecord);
                }
                if (times.isEmpty()) {
                    PlayerUtils.sendError("\u00a7cNo times found" + (targetTheme.isEmpty() ? "" : " for theme: " + targetTheme));
                    return;
                }
                times.sort((a, b) -> Double.compare((Double)a.get("bestTime"), (Double)b.get("bestTime")));
                PlayerUtils.sendLine();
                PlayerUtils.sendMessageWithPing("\u00a76Best Times" + (targetTheme.isEmpty() ? "" : " for " + targetTheme) + ":");
                for (Map map : times) {
                    PlayerUtils.sendMessage(String.format(" \u00a7b%s \u00a77(%s): \u00a7a%.2fs", map.get("theme"), map.get("difficulty"), map.get("bestTime")));
                }
                PlayerUtils.sendLine();
            }
            catch (Exception e) {
                PlayerUtils.sendError("\u00a7cError reading times: " + e.getMessage());
            }
        } else if (args[0].equalsIgnoreCase("overview")) {
            SpeedBuilderHelper instance = (SpeedBuilderHelper)((ModContainer)Loader.instance().getIndexedModList().get("speedbuilderhelper")).getMod();
            instance.showSessionBestTimesOverview();
        } else if (args[0].equalsIgnoreCase("reset")) {
            SpeedBuilderHelper instance = (SpeedBuilderHelper)((ModContainer)Loader.instance().getIndexedModList().get("speedbuilderhelper")).getMod();
            instance.clearSessionBestTimes();
        } else {
            PlayerUtils.sendError("Not a valid command!");
        }
    }

    public int func_82362_a() {
        return -1;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }
}

