/*
 * Decompiled with CFR 0.152.
 */
package box.com.speedbuilderhelper;

import box.com.speedbuilderhelper.MinecraftInstance;
import box.com.speedbuilderhelper.SpeedBuilderHelper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class PlayerUtils
implements MinecraftInstance {
    public static boolean nullCheck() {
        return PlayerUtils.mc.field_71439_g != null && PlayerUtils.mc.field_71441_e != null;
    }

    public static List<String> getSidebarLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (PlayerUtils.mc.field_71441_e == null) {
            return lines;
        }
        Scoreboard scoreboard = PlayerUtils.mc.field_71441_e.func_96441_U();
        if (scoreboard == null) {
            return lines;
        }
        ScoreObjective objective = scoreboard.func_96539_a(1);
        if (objective == null) {
            return lines;
        }
        ArrayList scores = scoreboard.func_96534_i(objective);
        ArrayList list = new ArrayList();
        for (Score input : scores) {
            if (input == null || input.func_96653_e() == null || input.func_96653_e().startsWith("#")) continue;
            list.add(input);
        }
        scores = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(list, (int)(scores.size() - 15))) : list;
        for (Score score : scores) {
            ScorePlayerTeam team = scoreboard.func_96509_i(score.func_96653_e());
            lines.add(ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e()));
        }
        return lines;
    }

    public static void sendMessage(String message) {
        if (!PlayerUtils.nullCheck()) {
            return;
        }
        String txt = PlayerUtils.replace("\u00a77[\u00a7dSpeedBuilders\u00a77]\u00a7r " + message);
        PlayerUtils.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(txt));
    }

    public static void sendMessageWithPing(String message) {
        if (!PlayerUtils.nullCheck()) {
            return;
        }
        String txt = PlayerUtils.replace("\u00a77[\u00a7dSpeedBuilders\u00a77]\u00a7r " + message);
        PlayerUtils.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(txt));
        PlayerUtils.ping();
    }

    public static void sendError(String message) {
        if (!PlayerUtils.nullCheck()) {
            return;
        }
        String txt = PlayerUtils.replace("\u00a77[\u00a7dSpeedBuilders\u00a77]\u00a7r " + message);
        PlayerUtils.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(txt));
        PlayerUtils.error();
    }

    public static void ping() {
        PlayerUtils.mc.field_71439_g.func_85030_a("note.pling", 1.0f, 1.0f);
    }

    public static void error() {
        PlayerUtils.mc.field_71439_g.func_85030_a("note.pling", 1.0f, 0.5f);
    }

    public static void debug(String message) {
        if (!SpeedBuilderHelper.Debug) {
            return;
        }
        String txt = PlayerUtils.replace("&7[&dDEBUG&7]&r " + message);
        PlayerUtils.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(txt));
    }

    public static void sendLine() {
        PlayerUtils.sendMessage("&7&m-------------------------");
    }

    public static String replace(String text) {
        return text.replace("&", "\u00a7").replace("%and", "&");
    }

    public static double round(double number, int decimals) {
        if (decimals == 0) {
            return Math.round(number);
        }
        double power = Math.pow(10.0, decimals);
        return (double)Math.round(number * power) / power;
    }

    public static boolean contains(List<String> list, String target) {
        for (String string : list) {
            if (!string.equalsIgnoreCase(target)) continue;
            return true;
        }
        return false;
    }
}

