/*
 * Decompiled with CFR 0.152.
 */
package box.com.speedbuilderhelper;

import box.com.speedbuilderhelper.CMDS;
import box.com.speedbuilderhelper.PlayerUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="speedbuilderhelper", version="1.0", acceptedMinecraftVersions="[1.8.9]")
public class SpeedBuilderHelper {
    public static final String MODID = "speedbuilderhelper";
    public static final String VERSION = "1.0";
    public static final Logger LOG = LogManager.getLogger((String)"SPEEDBUILDERS");
    public static final File Directory = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "SpeedBuildersHelper");
    private static final File TIMES_FILE = new File(Directory, "speedbuilder_times.json");
    private static final File CONFIG_FILE = new File(Directory, "speedbuildershelper.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static String playerName;
    private List<BuildRecord> times = new ArrayList<BuildRecord>();
    private List<BuildRecord> sessionTimes = new ArrayList<BuildRecord>();
    private List<BuildRecord> sessionBestTimes = new ArrayList<BuildRecord>();
    private String currentTheme = "";
    private String currentDifficulty = "";
    private String lastTrackedTheme = "";
    private String lastTrackedDifficulty = "";
    public static boolean Debug;
    private boolean gameOverDisplayed = false;
    public static boolean Activated;
    public static boolean StartingMessage;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!Directory.exists()) {
            Directory.mkdirs();
        }
        ClientCommandHandler.instance.func_71560_a((ICommand)new CMDS());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadTimes();
        this.loadConfig();
    }

    public void clearSessionBestTimes() {
        this.sessionBestTimes.clear();
        PlayerUtils.sendMessageWithPing("\u00a7eSession best times have been reset.");
    }

    public List<BuildRecord> getSessionBestTimes() {
        return this.sessionBestTimes;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        boolean difficultyChanged;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || !Activated) {
            return;
        }
        List<String> sidebarLines = PlayerUtils.getSidebarLines();
        String oldTheme = this.currentTheme;
        String oldDifficulty = this.currentDifficulty;
        for (String line : sidebarLines) {
            if (line.startsWith("Theme: ")) {
                this.currentTheme = line.substring(7).trim();
                continue;
            }
            if (line.startsWith("Difficulty: ")) {
                this.currentDifficulty = line.substring(11).trim();
                continue;
            }
            if (!line.contains("Game Over!") || this.gameOverDisplayed) continue;
            this.showSessionOverview();
            this.sessionTimes.clear();
            this.gameOverDisplayed = true;
        }
        boolean themeChanged = !this.currentTheme.equals(oldTheme) && !this.currentTheme.isEmpty();
        boolean bl = difficultyChanged = !this.currentDifficulty.equals(oldDifficulty) && !this.currentDifficulty.isEmpty();
        if (!(!themeChanged && !difficultyChanged || this.currentTheme.equals(this.lastTrackedTheme) && this.currentDifficulty.equals(this.lastTrackedDifficulty))) {
            this.gameOverDisplayed = false;
            if (themeChanged) {
                PlayerUtils.debug("Theme: " + this.currentTheme);
            }
            if (difficultyChanged) {
                PlayerUtils.debug("Difficulty: " + this.currentDifficulty);
            }
            if (!this.currentTheme.isEmpty() && !this.currentDifficulty.isEmpty()) {
                this.showBestTime(this.currentTheme, this.currentDifficulty);
                this.lastTrackedTheme = this.currentTheme;
                this.lastTrackedDifficulty = this.currentDifficulty;
            }
        }
    }

    private void showBestTime(String theme, String difficulty) {
        if (!StartingMessage) {
            return;
        }
        String cleanTheme = this.cleanText(theme);
        String cleanDifficulty = this.cleanText(difficulty);
        for (BuildRecord record : this.times) {
            if (!record.theme.equalsIgnoreCase(cleanTheme) || !record.difficulty.equalsIgnoreCase(cleanDifficulty)) continue;
            PlayerUtils.sendMessage("\u00a7b" + cleanTheme + " \u00a77(" + cleanDifficulty + ") \u00a7eBest Time: \u00a7a" + PlayerUtils.round(record.bestTime, 2) + "s");
            return;
        }
        PlayerUtils.sendMessage("\u00a7b" + cleanTheme + " \u00a77(" + cleanDifficulty + ") \u00a7eNo previous record");
    }

    private String cleanText(String text) {
        return text.replaceAll("\u00a7.", "").replaceAll("[^\\x00-\\x7F]", "").replaceFirst("(?i)Theme: ", "").replaceFirst("(?i)Difficulty: ", "").trim();
    }

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        if (!Activated) {
            return;
        }
        String message = event.message.func_150260_c();
        Pattern pattern = Pattern.compile("(.*) got a perfect build in (.*)s!");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find() && matcher.group(1).equals(playerName)) {
            double time = Double.parseDouble(matcher.group(2));
            boolean isNewBestTime = this.updateTime(this.currentTheme, this.currentDifficulty, time);
            this.sessionTimes.add(new BuildRecord(this.cleanText(this.currentTheme), this.cleanText(this.currentDifficulty), time));
            if (isNewBestTime) {
                this.updateSessionBestTimes(this.cleanText(this.currentTheme), this.cleanText(this.currentDifficulty), time);
            }
        }
    }

    private boolean updateTime(String theme, String difficulty, double time) {
        String cleanTheme = this.cleanText(theme);
        String cleanDifficulty = this.cleanText(difficulty);
        boolean isNewBest = false;
        for (BuildRecord record : this.times) {
            if (!record.theme.equals(cleanTheme) || !record.difficulty.equals(cleanDifficulty)) continue;
            if (time < record.bestTime) {
                record.bestTime = time;
                this.saveTimes();
                PlayerUtils.sendMessage("\u00a7a\u00a7lNew Best Time! " + cleanTheme + " (" + cleanDifficulty + "): \u00a7b" + time + "\u00a77s");
                isNewBest = true;
            } else {
                PlayerUtils.sendMessage("\u00a7aCompleted " + cleanTheme + " (" + cleanDifficulty + "): \u00a7b" + time + "\u00a77s, Previous: " + record.bestTime + "s");
            }
            return isNewBest;
        }
        this.times.add(new BuildRecord(cleanTheme, cleanDifficulty, time));
        this.saveTimes();
        PlayerUtils.sendMessage("\u00a7aFirst completion! \u00a7b" + cleanTheme + " (" + cleanDifficulty + ")\u00a7a in \u00a7b" + time + "\u00a77s!");
        isNewBest = true;
        return isNewBest;
    }

    private void updateSessionBestTimes(String theme, String difficulty, double time) {
        for (BuildRecord record : this.sessionBestTimes) {
            if (!record.theme.equalsIgnoreCase(theme) || !record.difficulty.equalsIgnoreCase(difficulty)) continue;
            if (time < record.bestTime) {
                record.bestTime = time;
            }
            return;
        }
        BuildRecord newRecord = new BuildRecord(theme, difficulty, time, true);
        this.sessionBestTimes.add(newRecord);
    }

    private void showSessionOverview() {
        if (this.sessionTimes.isEmpty()) {
            PlayerUtils.sendMessage("\u00a7cNo builds completed this game.");
            return;
        }
        PlayerUtils.sendMessage("\u00a76=== Game Overview ===");
        for (BuildRecord record : this.sessionTimes) {
            double bestTime = this.getBestTime(record.theme, record.difficulty);
            boolean isNewBest = record.bestTime <= bestTime;
            String timeMessage = "\u00a7b" + record.theme + " \u00a77(" + record.difficulty + ") \u00a7eTime: \u00a7a" + PlayerUtils.round(record.bestTime, 2) + "s";
            timeMessage = isNewBest ? timeMessage + " \u00a76(New Best!)" : timeMessage + " \u00a77[Best: " + PlayerUtils.round(bestTime, 2) + "s]";
            PlayerUtils.sendMessage(timeMessage);
        }
    }

    public void showSessionBestTimesOverview() {
        if (this.sessionBestTimes.isEmpty()) {
            PlayerUtils.sendMessage("\u00a7cNo new best times recorded this session.");
            return;
        }
        PlayerUtils.sendLine();
        PlayerUtils.sendMessageWithPing("\u00a76=== Session Best Times ===");
        this.sessionBestTimes.sort((a, b) -> Double.compare(a.bestTime, b.bestTime));
        for (BuildRecord record : this.sessionBestTimes) {
            PlayerUtils.sendMessage("\u00a7b" + record.theme + " \u00a77(" + record.difficulty + ") \u00a7eBest: \u00a7a" + PlayerUtils.round(record.bestTime, 2) + "s");
        }
        PlayerUtils.sendLine();
    }

    private double getBestTime(String theme, String difficulty) {
        for (BuildRecord record : this.times) {
            if (!record.theme.equalsIgnoreCase(theme) || !record.difficulty.equalsIgnoreCase(difficulty)) continue;
            return record.bestTime;
        }
        return Double.MAX_VALUE;
    }

    private void loadTimes() {
        if (!TIMES_FILE.exists()) {
            try {
                TIMES_FILE.createNewFile();
                this.saveTimes();
                LOG.info("Created Times File " + TIMES_FILE.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("Failed to create times file: " + e.getMessage());
                e.printStackTrace();
            }
            return;
        }
        try (FileReader reader = new FileReader(TIMES_FILE);){
            Type type = new TypeToken<HashMap<String, List<BuildRecord>>>(){}.getType();
            Map data = (Map)GSON.fromJson((Reader)reader, type);
            if (data != null && data.containsKey("themes")) {
                this.times = (List)data.get("themes");
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read times file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveTimes() {
        try (FileWriter writer = new FileWriter(TIMES_FILE);){
            HashMap<String, List<BuildRecord>> data = new HashMap<String, List<BuildRecord>>();
            data.put("themes", this.times);
            GSON.toJson(data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            Activated = true;
            StartingMessage = true;
            Debug = false;
            playerName = "";
            SpeedBuilderHelper.saveConfig();
            LOG.info("Created Config File " + CONFIG_FILE.getAbsolutePath());
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json != null) {
                Activated = json.has("activated") ? json.get("activated").getAsBoolean() : true;
                StartingMessage = json.has("startingMessage") ? json.get("startingMessage").getAsBoolean() : true;
                Debug = json.has("debug") ? json.get("debug").getAsBoolean() : false;
                playerName = json.has("playerName") ? json.get("playerName").getAsString() : "";
                LOG.info("Loaded config: activated=" + Activated + ", startingMessage=" + StartingMessage + ", debug=" + Debug + ", playerName=" + playerName);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read config file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            JsonObject json = new JsonObject();
            json.addProperty("activated", Boolean.valueOf(Activated));
            json.addProperty("startingMessage", Boolean.valueOf(StartingMessage));
            json.addProperty("debug", Boolean.valueOf(Debug));
            json.addProperty("playerName", playerName != null ? playerName : "");
            GSON.toJson((JsonElement)json, (Appendable)writer);
            LOG.info("Saved config: activated=" + Activated + ", startingMessage=" + StartingMessage + ", debug=" + Debug + ", playerName=" + playerName);
        }
        catch (IOException e) {
            LOG.error("Failed to save config file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        Debug = false;
        Activated = false;
        StartingMessage = false;
    }

    public static class BuildRecord {
        String theme;
        String difficulty;
        double bestTime;
        boolean isNewBest;

        BuildRecord(String theme, String difficulty, double time) {
            this.theme = theme.replaceAll("\u00a7.", "");
            this.difficulty = difficulty.replaceAll("\u00a7.", "");
            this.bestTime = time;
            this.isNewBest = false;
        }

        BuildRecord(String theme, String difficulty, double time, boolean isNewBest) {
            this.theme = theme.replaceAll("\u00a7.", "");
            this.difficulty = difficulty.replaceAll("\u00a7.", "");
            this.bestTime = time;
            this.isNewBest = isNewBest;
        }
    }
}

