/*
 * Decompiled with CFR 0.152.
 */
package box.com;

import box.com.PlayerUtils;
import box.com.SpeedBuildersHelper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

@Environment(value=EnvType.CLIENT)
public class CMDS {
    private static final File TIMES_FILE = new File(SpeedBuildersHelper.DIRECTORY, "speedbuilder_times.json");
    private static final Gson GSON = new Gson();
    private static SpeedBuildersHelper helperInstance;

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CMDS.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    public static void setHelperInstance(SpeedBuildersHelper instance) {
        helperInstance = instance;
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode speedbuildersNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"speedbuilders").executes(CMDS::showHelp)).then(ClientCommandManager.literal((String)"debug").executes(CMDS::toggleDebug))).then(ClientCommandManager.literal((String)"toggle").executes(CMDS::toggleMod))).then(ClientCommandManager.literal((String)"showtime").executes(CMDS::toggleShowTime))).then(ClientCommandManager.literal((String)"setname").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> CMDS.setName((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"times").executes(CMDS::showTimes)).then(ClientCommandManager.argument((String)"theme", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CMDS.showTimes((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"theme")))))).then(ClientCommandManager.literal((String)"overview").executes(CMDS::showOverview))).then(ClientCommandManager.literal((String)"reset").executes(CMDS::resetSession))).then(ClientCommandManager.literal((String)"debugtest").executes(CMDS::debugTest)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sb").executes(CMDS::showHelp)).redirect((CommandNode)speedbuildersNode));
    }

    private static int showHelp(CommandContext<FabricClientCommandSource> context) {
        PlayerUtils.sendLine();
        PlayerUtils.sendMessageWithPing("\u00a7eSpeed-Builder Helper Commands");
        PlayerUtils.sendMessage(" \u00a73/speedbuilders debug\u00a77: enables / disables debugging");
        PlayerUtils.sendMessage(" \u00a73/speedbuilders toggle\u00a77: enables / disables speed-builder helper");
        PlayerUtils.sendMessage(" \u00a73/speedbuilders setname\u00a77: sets your username to what you input");
        PlayerUtils.sendMessage(" \u00a73/speedbuilders times\u00a77: shows your best times sorted by speed");
        PlayerUtils.sendMessage(" \u00a73/speedbuilders showtime\u00a77: shows your best time for the theme you are currently playing");
        PlayerUtils.sendMessage(" \u00a73/speedbuilders overview\u00a77: shows all new best times achieved this session");
        PlayerUtils.sendMessage(" \u00a73/speedbuilders reset\u00a77: clears the session best times list");
        PlayerUtils.sendLine();
        return 1;
    }

    private static int debugTest(CommandContext<FabricClientCommandSource> context) {
        PlayerUtils.debug("TESTING DEBUG MESSAGE");
        return 1;
    }

    private static int toggleDebug(CommandContext<FabricClientCommandSource> context) {
        SpeedBuildersHelper.Debug = !SpeedBuildersHelper.Debug;
        PlayerUtils.sendMessageWithPing("&eDebug has been " + (SpeedBuildersHelper.Debug ? "&aenabled" : "&cdisabled") + "&e.");
        SpeedBuildersHelper.saveConfig();
        return 1;
    }

    private static int toggleMod(CommandContext<FabricClientCommandSource> context) {
        SpeedBuildersHelper.Activated = !SpeedBuildersHelper.Activated;
        PlayerUtils.sendMessageWithPing("&espeed-builder helper has been " + (SpeedBuildersHelper.Activated ? "&aenabled" : "&cdisabled") + "&e.");
        SpeedBuildersHelper.saveConfig();
        return 1;
    }

    private static int toggleShowTime(CommandContext<FabricClientCommandSource> context) {
        SpeedBuildersHelper.StartingMessage = !SpeedBuildersHelper.StartingMessage;
        PlayerUtils.sendMessageWithPing("&eShow Times has been " + (SpeedBuildersHelper.StartingMessage ? "&aenabled" : "&cdisabled") + "&e.");
        SpeedBuildersHelper.saveConfig();
        return 1;
    }

    private static int setName(CommandContext<FabricClientCommandSource> context, String name) {
        SpeedBuildersHelper.playerName = name;
        PlayerUtils.sendMessageWithPing("&eSet name to &3" + name);
        SpeedBuildersHelper.saveConfig();
        return 1;
    }

    private static int showTimes(CommandContext<FabricClientCommandSource> context) {
        return CMDS.showTimes(context, "");
    }

    private static int showTimes(CommandContext<FabricClientCommandSource> context, String targetTheme) {
        try {
            if (!TIMES_FILE.exists()) {
                PlayerUtils.sendError("\u00a7cNo times recorded yet!");
                return 0;
            }
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new FileReader(TIMES_FILE), JsonObject.class);
            JsonArray themesArray = json.getAsJsonArray("themes");
            ArrayList times = new ArrayList();
            for (JsonElement jsonElement : themesArray) {
                JsonObject record = jsonElement.getAsJsonObject();
                if (!targetTheme.isEmpty() && !record.get("theme").getAsString().toLowerCase().contains(targetTheme.toLowerCase())) continue;
                HashMap<String, Object> timeRecord = new HashMap<String, Object>();
                timeRecord.put("theme", record.get("theme").getAsString());
                timeRecord.put("difficulty", record.get("difficulty").getAsString());
                timeRecord.put("bestTime", record.get("bestTime").getAsDouble());
                if (record.has("variant") && !record.get("variant").getAsString().isEmpty()) {
                    timeRecord.put("variant", record.get("variant").getAsString());
                }
                times.add(timeRecord);
            }
            if (times.isEmpty()) {
                PlayerUtils.sendError("\u00a7cNo times found" + (String)(targetTheme.isEmpty() ? "" : " for theme: " + targetTheme));
                return 0;
            }
            times.sort((a, b) -> Double.compare((Double)a.get("bestTime"), (Double)b.get("bestTime")));
            PlayerUtils.sendLine();
            PlayerUtils.sendMessageWithPing("\u00a76Best Times" + (String)(targetTheme.isEmpty() ? "" : " for " + targetTheme) + ":");
            for (Map map : times) {
                String theme = (String)map.get("theme");
                String difficulty = (String)map.get("difficulty");
                double bestTime = (Double)map.get("bestTime");
                String variant = map.containsKey("variant") ? " (" + String.valueOf(map.get("variant")) + ")" : "";
                PlayerUtils.sendMessage(String.format(" \u00a7b%s%s \u00a77(%s): \u00a7a%.2fs", theme, variant, difficulty, bestTime));
            }
            PlayerUtils.sendLine();
            return 1;
        }
        catch (Exception e) {
            PlayerUtils.sendError("\u00a7cError reading times: " + e.getMessage());
            return 0;
        }
    }

    private static int showOverview(CommandContext<FabricClientCommandSource> context) {
        if (helperInstance != null) {
            helperInstance.showSessionBestTimesOverview();
            return 1;
        }
        PlayerUtils.sendError("\u00a7cError: Helper instance not available");
        return 0;
    }

    private static int resetSession(CommandContext<FabricClientCommandSource> context) {
        if (helperInstance != null) {
            helperInstance.clearSessionBestTimes();
            return 1;
        }
        PlayerUtils.sendError("\u00a7cError: Helper instance not available");
        return 0;
    }
}

