/*
 * Decompiled with CFR 0.152.
 */
package box.com;

import box.com.CMDS;
import box.com.MinecraftInstance;
import box.com.PlayerUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class SpeedBuildersHelper
implements ClientModInitializer {
    public static final String MODID = "speedbuilderhelper";
    public static final String VERSION = "1.1";
    public static final Logger LOG = LogManager.getLogger((String)"SPEEDBUILDERS");
    public static File DIRECTORY = new File(class_310.method_1551().field_1697, "SpeedBuildersHelper");
    private static final File TIMES_FILE = new File(DIRECTORY, "speedbuilder_times.json");
    private static final File CONFIG_FILE = new File(DIRECTORY, "speedbuildershelper.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static String playerName;
    private List<BuildRecord> times = new ArrayList<BuildRecord>();
    private List<BuildRecord> sessionTimes = new ArrayList<BuildRecord>();
    private List<BuildRecord> sessionBestTimes = new ArrayList<BuildRecord>();
    private String currentTheme = "";
    private String currentDifficulty = "";
    private String currentVariant = "";
    private String lastTrackedTheme = "";
    private String lastTrackedDifficulty = "";
    private String lastTrackedVariant = "";
    public static boolean Debug;
    private boolean gameOverDisplayed = false;
    public static boolean Activated;
    public static boolean StartingMessage;
    private boolean variantDetectionActive = false;
    private boolean statsShown = false;
    private long lastVariantScanTime = 0L;
    private static final long VARIANT_SCAN_COOLDOWN = 1000L;

    public void onInitializeClient() {
        if (!DIRECTORY.exists()) {
            DIRECTORY.mkdirs();
        }
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientReceiveMessageEvents.GAME.register(this::onChat);
        CMDS.setHelperInstance(this);
        CMDS.register();
        this.loadTimes();
        this.loadConfig();
    }

    public void clearSessionBestTimes() {
        this.sessionBestTimes.clear();
        PlayerUtils.sendMessageWithPing("\u00a7eSession best times have been reset.");
    }

    public List<BuildRecord> getSessionBestTimes() {
        return this.sessionBestTimes;
    }

    private void onClientTick(class_310 client) {
        boolean difficultyChanged;
        if (client.field_1687 == null || client.field_1724 == null || !Activated) {
            return;
        }
        PlayerUtils.updateScoreboard(MinecraftInstance.mc);
        String oldTheme = this.currentTheme;
        String oldDifficulty = this.currentDifficulty;
        for (String line : PlayerUtils.STRING_SCOREBOARD) {
            if (line.toLowerCase().contains("theme:")) {
                String extractedTheme;
                this.currentTheme = extractedTheme = line.substring(line.toLowerCase().indexOf("theme:") + 6).trim();
                PlayerUtils.debug("Found theme: '" + this.currentTheme + "' from line: '" + line + "'");
                continue;
            }
            if (line.toLowerCase().contains("difficulty:")) {
                String extractedDifficulty;
                this.currentDifficulty = extractedDifficulty = line.substring(line.toLowerCase().indexOf("difficulty:") + 11).trim();
                PlayerUtils.debug("Found difficulty: '" + this.currentDifficulty + "' from line: '" + line + "'");
                continue;
            }
            if (!line.contains("Game Over!")) continue;
            PlayerUtils.debug("Game over detected in scoreboard");
            if (this.gameOverDisplayed) continue;
            this.showSessionOverview();
            this.sessionTimes.clear();
            this.gameOverDisplayed = true;
        }
        boolean themeChanged = !this.currentTheme.equals(oldTheme) && !this.currentTheme.isEmpty();
        boolean bl = difficultyChanged = !this.currentDifficulty.equals(oldDifficulty) && !this.currentDifficulty.isEmpty();
        if (themeChanged) {
            PlayerUtils.debug("THEME CHANGED from '" + oldTheme + "' to '" + this.currentTheme + "'");
        }
        if (difficultyChanged) {
            PlayerUtils.debug("DIFFICULTY CHANGED from '" + oldDifficulty + "' to '" + this.currentDifficulty + "'");
        }
        if (themeChanged && !this.currentTheme.isEmpty()) {
            this.variantDetectionActive = true;
            this.lastVariantScanTime = System.currentTimeMillis();
            PlayerUtils.debug("Starting variant detection for theme: " + this.currentTheme);
        }
        if (this.variantDetectionActive && System.currentTimeMillis() - this.lastVariantScanTime > 1000L) {
            String newVariant = this.detectVariant(this.cleanText(this.currentTheme));
            if (!newVariant.isEmpty()) {
                this.currentVariant = newVariant;
                this.variantDetectionActive = false;
                PlayerUtils.debug("Detected variant: " + this.currentVariant + " for theme: " + this.currentTheme);
                if (!(this.statsShown || this.currentTheme.isEmpty() || this.currentDifficulty.isEmpty())) {
                    this.showBestTime(this.currentTheme, this.currentDifficulty, this.currentVariant);
                    this.lastTrackedTheme = this.currentTheme;
                    this.lastTrackedDifficulty = this.currentDifficulty;
                    this.lastTrackedVariant = this.currentVariant;
                    this.statsShown = true;
                }
            }
            this.lastVariantScanTime = System.currentTimeMillis();
            if (System.currentTimeMillis() - this.lastVariantScanTime > 10000L) {
                this.variantDetectionActive = false;
                PlayerUtils.debug("Stopped variant detection for theme: " + this.currentTheme);
            }
        }
        if (!(!themeChanged && !difficultyChanged || this.currentTheme.equals(this.lastTrackedTheme) && this.currentDifficulty.equals(this.lastTrackedDifficulty) && this.currentVariant.equals(this.lastTrackedVariant))) {
            this.gameOverDisplayed = false;
            if (themeChanged) {
                this.currentVariant = "";
                PlayerUtils.debug("Theme: " + this.currentTheme);
                this.variantDetectionActive = this.requiresVariantDetection(this.cleanText(this.currentTheme));
                if (this.variantDetectionActive) {
                    this.lastVariantScanTime = System.currentTimeMillis();
                    PlayerUtils.debug("Starting variant detection for theme: " + this.currentTheme);
                }
            }
            if (difficultyChanged) {
                PlayerUtils.debug("Difficulty: " + this.currentDifficulty);
            }
            if (!this.currentTheme.isEmpty() && !this.currentDifficulty.isEmpty()) {
                if (!this.requiresVariantDetection(this.cleanText(this.currentTheme)) || !this.currentVariant.isEmpty()) {
                    this.showBestTime(this.currentTheme, this.currentDifficulty, this.currentVariant);
                    this.lastTrackedTheme = this.currentTheme;
                    this.lastTrackedDifficulty = this.currentDifficulty;
                    this.lastTrackedVariant = this.currentVariant;
                    this.statsShown = true;
                } else {
                    this.statsShown = false;
                }
            }
        }
    }

    private boolean requiresVariantDetection(String theme) {
        return theme.equalsIgnoreCase("Painting") || theme.equalsIgnoreCase("ClownFish");
    }

    private String detectVariant(String theme) {
        if (theme.equalsIgnoreCase("Painting")) {
            return this.detectPaintingVariant();
        }
        if (theme.equalsIgnoreCase("ClownFish")) {
            return this.detectClownFishVariant();
        }
        return "";
    }

    private String detectPaintingVariant() {
        boolean hasSpruce = this.checkForBlockInBuildArea("spruce_planks");
        return hasSpruce ? "Horizontal" : "Vertical";
    }

    private String detectClownFishVariant() {
        int blackWoolCount = this.countBlocksInBuildArea("black_wool");
        return blackWoolCount == 1 ? "Small" : "Medium";
    }

    private boolean checkForBlockInBuildArea(String blockId) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        int px = (int)client.field_1724.method_23317();
        int py = (int)client.field_1724.method_23318();
        int pz = (int)client.field_1724.method_23321();
        int radius = 15;
        for (int x = px - radius; x <= px + radius; ++x) {
            for (int y = py - radius; y <= py + radius; ++y) {
                for (int z = pz - radius; z <= pz + radius; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2248 block = client.field_1687.method_8320(pos).method_26204();
                    if (!block.method_9539().toLowerCase().contains(blockId.toLowerCase())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int countBlocksInBuildArea(String blockId) {
        int count = 0;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return count;
        }
        int px = (int)client.field_1724.method_23317();
        int py = (int)client.field_1724.method_23318();
        int pz = (int)client.field_1724.method_23321();
        int radius = 15;
        for (int x = px - radius; x <= px + radius; ++x) {
            for (int y = py - radius; y <= py + radius; ++y) {
                for (int z = pz - radius; z <= pz + radius; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2248 block = client.field_1687.method_8320(pos).method_26204();
                    if (!block.method_9539().toLowerCase().contains(blockId.toLowerCase())) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private void showBestTime(String theme, String difficulty, String variant) {
        if (!StartingMessage) {
            return;
        }
        String cleanTheme = this.cleanText(theme);
        String cleanDifficulty = this.cleanText(difficulty);
        for (BuildRecord record : this.times) {
            if (!record.theme.equalsIgnoreCase(cleanTheme) || !record.difficulty.equalsIgnoreCase(cleanDifficulty) || !record.variant.equals(variant)) continue;
            Object variantDisplay = variant.isEmpty() ? "" : " (" + variant + ")";
            PlayerUtils.sendMessage("\u00a7b" + cleanTheme + (String)variantDisplay + " \u00a77(" + cleanDifficulty + ") \u00a7eBest Time: \u00a7a" + PlayerUtils.round(record.bestTime, 2) + "s");
            return;
        }
        Object variantDisplay = variant.isEmpty() ? "" : " (" + variant + ")";
        PlayerUtils.sendMessage("\u00a7b" + cleanTheme + (String)variantDisplay + " \u00a77(" + cleanDifficulty + ") \u00a7eNo previous record");
    }

    private String cleanText(String text) {
        return text.replaceAll("\u00a7.", "").replaceAll("[^\\x00-\\x7F]", "").replaceFirst("(?i)Theme: ", "").replaceFirst("(?i)Difficulty: ", "").trim();
    }

    private void onChat(class_2561 message, boolean overlay) {
        if (!Activated) {
            return;
        }
        String messageStr = message.getString();
        Pattern pattern = Pattern.compile("(.*) got a perfect build in (.*)s!");
        Matcher matcher = pattern.matcher(messageStr);
        if (matcher.find() && matcher.group(1).equals(playerName)) {
            double time = Double.parseDouble(matcher.group(2));
            boolean isNewBestTime = this.updateTime(this.currentTheme, this.currentDifficulty, this.currentVariant, time);
            this.sessionTimes.add(new BuildRecord(this.cleanText(this.currentTheme), this.cleanText(this.currentDifficulty), this.currentVariant, time));
            if (isNewBestTime) {
                this.updateSessionBestTimes(this.cleanText(this.currentTheme), this.cleanText(this.currentDifficulty), this.currentVariant, time);
            }
        }
    }

    private boolean updateTime(String theme, String difficulty, String variant, double time) {
        String cleanTheme = this.cleanText(theme);
        String cleanDifficulty = this.cleanText(difficulty);
        boolean isNewBest = false;
        for (BuildRecord record : this.times) {
            if (!record.theme.equals(cleanTheme) || !record.difficulty.equals(cleanDifficulty) || !record.variant.equals(variant)) continue;
            if (time < record.bestTime) {
                double oldBest = record.bestTime;
                record.bestTime = time;
                double increase = PlayerUtils.round(record.bestTime - oldBest, 1);
                this.saveTimes();
                Object variantDisplay = variant.isEmpty() ? "" : " (" + variant + ")";
                PlayerUtils.sendMessage("\u00a7a\u00a7lNew Best Time! " + cleanTheme + (String)variantDisplay + " (" + cleanDifficulty + "): \u00a7b" + time + "\u00a77s \u00a7b" + increase + "\u00a77s");
                isNewBest = true;
            } else {
                Object variantDisplay = variant.isEmpty() ? "" : " (" + variant + ")";
                PlayerUtils.sendMessage("\u00a7aCompleted " + cleanTheme + (String)variantDisplay + " (" + cleanDifficulty + "): \u00a7b" + time + "\u00a77s, Previous: " + record.bestTime + "s");
            }
            return isNewBest;
        }
        this.times.add(new BuildRecord(cleanTheme, cleanDifficulty, variant, time));
        this.saveTimes();
        Object variantDisplay = variant.isEmpty() ? "" : " (" + variant + ")";
        PlayerUtils.sendMessage("\u00a7aFirst completion! \u00a7b" + cleanTheme + (String)variantDisplay + " (" + cleanDifficulty + ")\u00a7a in \u00a7b" + time + "\u00a77s!");
        isNewBest = true;
        return isNewBest;
    }

    private void updateSessionBestTimes(String theme, String difficulty, String variant, double time) {
        for (BuildRecord record : this.sessionBestTimes) {
            if (!record.theme.equalsIgnoreCase(theme) || !record.difficulty.equalsIgnoreCase(difficulty) || !record.variant.equals(variant)) continue;
            if (time < record.bestTime) {
                record.bestTime = time;
            }
            return;
        }
        BuildRecord newRecord = new BuildRecord(theme, difficulty, variant, time, true);
        this.sessionBestTimes.add(newRecord);
    }

    public void showSessionOverview() {
        if (this.sessionTimes.isEmpty()) {
            PlayerUtils.sendMessage("\u00a7cNo builds completed this game.");
            return;
        }
        PlayerUtils.sendMessage("\u00a76=== Game Overview ===");
        for (BuildRecord record : this.sessionTimes) {
            double bestTime = this.getBestTime(record.theme, record.difficulty, record.variant);
            boolean isNewBest = record.bestTime <= bestTime;
            String variantDisplay = record.variant.isEmpty() ? "" : " (" + record.variant + ")";
            String timeMessage = "\u00a7b" + record.theme + variantDisplay + " \u00a77(" + record.difficulty + ") \u00a7eTime: \u00a7a" + PlayerUtils.round(record.bestTime, 2) + "s";
            timeMessage = isNewBest ? timeMessage + " \u00a76(New Best!)" : timeMessage + " \u00a77[Best: " + PlayerUtils.round(bestTime, 2) + "s]";
            PlayerUtils.sendMessage(timeMessage);
        }
    }

    public void showSessionBestTimesOverview() {
        if (this.sessionBestTimes.isEmpty()) {
            PlayerUtils.sendMessage("\u00a7cNo new best times recorded this session.");
            return;
        }
        PlayerUtils.sendLine();
        PlayerUtils.sendMessageWithPing("\u00a76=== Session Best Times ===");
        this.sessionBestTimes.sort((a, b) -> Double.compare(a.bestTime, b.bestTime));
        for (BuildRecord record : this.sessionBestTimes) {
            String variantDisplay = record.variant.isEmpty() ? "" : " (" + record.variant + ")";
            PlayerUtils.sendMessage("\u00a7b" + record.theme + variantDisplay + " \u00a77(" + record.difficulty + ") \u00a7eBest: \u00a7a" + PlayerUtils.round(record.bestTime, 2) + "s");
        }
        PlayerUtils.sendLine();
    }

    private double getBestTime(String theme, String difficulty, String variant) {
        for (BuildRecord record : this.times) {
            if (!record.theme.equalsIgnoreCase(theme) || !record.difficulty.equalsIgnoreCase(difficulty) || !record.variant.equals(variant)) continue;
            return record.bestTime;
        }
        return Double.MAX_VALUE;
    }

    private void loadTimes() {
        if (!TIMES_FILE.exists()) {
            try {
                TIMES_FILE.createNewFile();
                this.saveTimes();
                LOG.info("Created Times File " + TIMES_FILE.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("Failed to create times file: " + e.getMessage());
                e.printStackTrace();
            }
            return;
        }
        try (FileReader reader = new FileReader(TIMES_FILE);){
            Type type = new TypeToken<HashMap<String, List<BuildRecord>>>(this){}.getType();
            Map data = (Map)GSON.fromJson((Reader)reader, type);
            if (data != null && data.containsKey("themes")) {
                this.times = (List)data.get("themes");
                this.migrateOldRecords();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read times file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void migrateOldRecords() {
        boolean needsMigration = false;
        for (BuildRecord record : this.times) {
            if (record.variant != null) continue;
            needsMigration = true;
            break;
        }
        if (needsMigration) {
            LOG.info("Migrating old records to new format with variant field");
            ArrayList<BuildRecord> newRecords = new ArrayList<BuildRecord>();
            for (BuildRecord oldRecord : this.times) {
                if (oldRecord.variant == null) {
                    BuildRecord newRecord = new BuildRecord(oldRecord.theme, oldRecord.difficulty, "", oldRecord.bestTime, oldRecord.isNewBest);
                    newRecords.add(newRecord);
                    continue;
                }
                newRecords.add(oldRecord);
            }
            this.times = newRecords;
            this.saveTimes();
            LOG.info("Migration completed successfully");
        }
    }

    private void saveTimes() {
        try (FileWriter writer = new FileWriter(TIMES_FILE);){
            HashMap<String, List<BuildRecord>> data = new HashMap<String, List<BuildRecord>>();
            data.put("themes", this.times);
            GSON.toJson(data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            Activated = true;
            StartingMessage = true;
            Debug = false;
            playerName = "";
            SpeedBuildersHelper.saveConfig();
            LOG.info("Created Config File " + CONFIG_FILE.getAbsolutePath());
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json != null) {
                Activated = json.has("activated") ? json.get("activated").getAsBoolean() : true;
                StartingMessage = json.has("startingMessage") ? json.get("startingMessage").getAsBoolean() : true;
                Debug = json.has("debug") ? json.get("debug").getAsBoolean() : false;
                playerName = json.has("playerName") ? json.get("playerName").getAsString() : "";
                LOG.info("Loaded config: activated=" + Activated + ", startingMessage=" + StartingMessage + ", debug=" + Debug + ", playerName=" + playerName);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read config file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            JsonObject json = new JsonObject();
            json.addProperty("activated", Boolean.valueOf(Activated));
            json.addProperty("startingMessage", Boolean.valueOf(StartingMessage));
            json.addProperty("debug", Boolean.valueOf(Debug));
            json.addProperty("playerName", playerName != null ? playerName : "");
            GSON.toJson((JsonElement)json, (Appendable)writer);
            LOG.info("Saved config: activated=" + Activated + ", startingMessage=" + StartingMessage + ", debug=" + Debug + ", playerName=" + playerName);
        }
        catch (IOException e) {
            LOG.error("Failed to save config file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        Debug = false;
        Activated = false;
        StartingMessage = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class BuildRecord {
        String theme;
        String difficulty;
        String variant;
        double bestTime;
        boolean isNewBest;

        BuildRecord(String theme, String difficulty, String variant, double time) {
            this.theme = theme.replaceAll("\u00a7.", "");
            this.difficulty = difficulty.replaceAll("\u00a7.", "");
            this.variant = variant != null ? variant.replaceAll("\u00a7.", "") : "";
            this.bestTime = time;
            this.isNewBest = false;
        }

        BuildRecord(String theme, String difficulty, String variant, double time, boolean isNewBest) {
            this.theme = theme.replaceAll("\u00a7.", "");
            this.difficulty = difficulty.replaceAll("\u00a7.", "");
            this.variant = variant != null ? variant.replaceAll("\u00a7.", "") : "";
            this.bestTime = time;
            this.isNewBest = isNewBest;
        }
    }
}

