package io.github.xrickastley.originsmath.actions.bientity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.factory.action.ActionFactory; 
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.util.VariableSerializer;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;

public class VariableExecuteCommandAction {
	private static void action(SerializableData.Instance data, class_3545<class_1297, class_1297> entity) {
		final class_1297 actor = entity.method_15442();
		final class_1297 target = entity.method_15441();
		final MinecraftServer server = actor.method_37908().method_8503();

		if (server == null) return;
		
		final boolean validOutput = !(target instanceof final class_3222 serverTarget) || serverTarget.field_13987 != null;
		final class_2168 source = new class_2168(
			Apoli.config.executeCommand.showOutput && validOutput 
				? actor 
				: class_2165.field_17395,
			actor.method_19538(),
			actor.method_5802(),
			actor.method_37908() instanceof final class_3218 serverWorld
				? serverWorld
				: null,
			Apoli.config.executeCommand.permissionLevel,
			actor.method_5477().getString(),
			actor.method_5476(),
			server,
			actor
		);

		final VariableSerializer varSerializer = data.get("variables");
		final String actorSelector = data.getString("actor_selector");
		final String targetSelector = data.getString("target_selector");
		
		String commandString = data.getString("command")
			.replace(actorSelector, actor.method_5667().toString())
			.replace(targetSelector, target.method_5667().toString());

		for (String variable : varSerializer.getVariableMap().keySet()) {
			int value = varSerializer.getVariableValue(variable, actor);
			
			commandString = commandString
				.replace(String.format("$:%s", variable), String.valueOf(value))
				.replace(String.format("${%s}", variable), String.valueOf(value));
		}

		server
			.method_3734()
			.method_44252(source, commandString);
	}

	public static ActionFactory<class_3545<class_1297, class_1297>> getFactory() {
		return new ActionFactory<>(
			OriginsMath.identifier("variable_execute_command"),
			new SerializableData()
				.add("command", SerializableDataTypes.STRING)
				.add("actor_selector", SerializableDataTypes.STRING, "%a")
				.add("target_selector", SerializableDataTypes.STRING, "%t")
				.add("variables", VariableSerializer.SERIALIZABLE_DATATYPE, VariableSerializer.EMPTY),
			VariableExecuteCommandAction::action
		);
	}
}
