package io.github.xrickastley.originsmath.actions.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.util.VariableSerializer;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class VariableExecuteCommandAction {
	private static void action(SerializableData.Instance data, class_1297 entity) {
        final MinecraftServer server = entity.method_37908().method_8503();

		if (server == null) return;
		
        final boolean validOutput = !(entity instanceof class_3222) || ((class_3222) entity).field_13987 != null;
		final VariableSerializer varSerializer = data.get("variables");
        final class_2168 source = new class_2168(
            Apoli.config.executeCommand.showOutput && validOutput 
				? entity 
				: class_2165.field_17395,
            entity.method_19538(),
            entity.method_5802(),
            entity.method_37908() instanceof class_3218 
				? (class_3218) entity.method_37908() 
				: null,
            Apoli.config.executeCommand.permissionLevel,
            entity.method_5477().getString(),
            entity.method_5476(),
            entity.method_37908().method_8503(),
            entity
		);

		String commandString = data.getString("command");

		for (String variable : varSerializer.getVariableMap().keySet()) {
			int value = varSerializer.getVariableValue(variable, entity);
			
			commandString = commandString
				.replace(String.format("$:%s", variable), String.valueOf(value))
				.replace(String.format("${%s}", variable), String.valueOf(value));
		}

		server
			.method_3734()
			.method_44252(source, commandString);
	}

	public static ActionFactory<class_1297> getFactory() {
		return new ActionFactory<>(
			OriginsMath.identifier("variable_execute_command"),
			new SerializableData()
	            .add("command", SerializableDataTypes.STRING)
				.add("variables", VariableSerializer.SERIALIZABLE_DATATYPE, VariableSerializer.EMPTY),
			VariableExecuteCommandAction::action
		);
	}
}
