package io.github.xrickastley.originsmath.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import java.text.DecimalFormat;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.util.modifier.ModifierUtil;

public class ModifierCommand {
	public static void register(CommandDispatcher<class_2168> dispatcher) {
		dispatcher.register(
			class_2170
				.method_9247("modifier")
				.requires(cs -> cs.method_9259(2))
				.then(
					class_2170
						.method_9247("apply")
						.then(
							class_2170
								.method_9244("target", class_2186.method_9309())
								.then(
									class_2170
										.method_9244("power", PowerTypeArgumentType.power())
										.then(
											class_2170
												.method_9244("base", DoubleArgumentType.doubleArg())
												.executes(ModifierCommand::apply)
										)
								)
						)
				)
		);
	}

	private static int apply(final CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_2168 source = context.getSource();
		final class_1297 target = class_2186.method_9313(context, "target");
		final PowerHolderComponent component = PowerHolderComponent.KEY.get(target);

		final double base = DoubleArgumentType.getDouble(context, "base");
		final PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
		final Power power = component.getPower(powerType);

		if (power == null) {
			final class_2561 errorText = class_2561.method_30163(String.format("Entity %s doesn't have the requested power: %s", target.method_5477().getString(), powerType.getIdentifier()));
			errorText.method_10866().method_10977(class_124.field_1061);

			source.method_9213(errorText);

			return 0;
		}

		if (!(power instanceof final ValueModifyingPower vmp)) {
			final class_2561 errorText = class_2561.method_30163(String.format("Power type %s isn't a valid modifying power!", powerType.getIdentifier()));
			errorText.method_10866().method_10977(class_124.field_1061);

			source.method_9213(errorText);

			return 0;
		}

		final DecimalFormat df = new DecimalFormat("#.#####");

		source.method_9226(() -> class_2561.method_30163(String.format("Applied Modifier: %s\nBase value: %s\nModifier Result: %s", powerType.getIdentifier().toString(), df.format(base), df.format(ModifierUtil.applyModifiers(target, vmp.getModifiers(), base)))), false);

		return 1;
	}
}
