package io.github.xrickastley.originsmath.commands;

import com.chocohead.mm.api.ClassTinkerers;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.apace100.apoli.command.ResourceCommand.SubCommand;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.xrickastley.originsmath.powers.LinkedVariableIntPower;

public class ResourceCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            class_2170
                .method_9247("resource")
                .requires(cs -> cs.method_9259(2))
                .then(
                    class_2170
                        .method_9247("get")
                        .then(
                            class_2170
                                .method_9247("absolute")
                                .then(
                                    class_2170
                                        .method_9244("target", class_2186.method_9309())
                                        .then(
                                            class_2170
                                               .method_9244("power", PowerTypeArgumentType.power())
                                               .executes(command -> resource(command, ClassTinkerers.getEnum(SubCommand.class, "GET_ABSOLUTE")))
                                        )
                                )
                        )
                )
        );
    }

    private static int resource(CommandContext<class_2168> context, SubCommand subCommand) throws CommandSyntaxException {
		final SubCommand GetAbsolute = ClassTinkerers.getEnum(SubCommand.class, "GET_ABSOLUTE");

		if (subCommand != GetAbsolute) return 0;
        
        class_1297 player = class_2186.method_9313(context, "target");
        
        if (!(player instanceof class_1309)) {}

        class_2168 source = context.getSource();
        PowerType<?> powerType = PowerTypeArgumentType.getPower(context, "power");
        Optional<PowerHolderComponent> phc = PowerHolderComponent.KEY.maybeGet(player);
        
        if (phc.isEmpty()) {
            source.method_9213(class_2561.method_43471("commands.apoli.resource.invalid_entity"));
            
            return 0;
        }

        Power power = PowerHolderComponent.KEY.get(player).getPower(powerType);

		double value = getAbsoluteValue(power);

		source.method_9226(() -> class_2561.method_43469("commands.scoreboard.players.get.success", player.method_5477().getString(), value, powerType.getIdentifier()), true);

        return (int) value;
    }

    public static double getAbsoluteValue(Power power) {
		if (power instanceof LinkedVariableIntPower lvip) return lvip.supplyDoubleValue();
        else if (power instanceof VariableIntPower vip) return vip.getValue();
        else if (power instanceof CooldownPower cp) return cp.getRemainingTicks();
        else return 0;
    }

    public static double obtainResourceValue(class_1297 entity, PowerType<?> powerType) {
		final Power power = powerType.get(entity);

		if (power instanceof final LinkedVariableIntPower lvip) return lvip.supplyDoubleValue();
		else if (power instanceof final VariableIntPower vip) return vip.getValue();
		else if (power instanceof final CooldownPower cp) return cp.getRemainingTicks();
		else throw new RuntimeException(String.format("Attempted to use invalid power type \"%s\" as a resource!", powerType.getIdentifier().toString()));
	}
}