package io.github.xrickastley.originsmath.conditions.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.commands.ResourceCommand;
import net.minecraft.class_1297;

public class CompareResourcesCondition {
    private static boolean condition(SerializableData.Instance data, class_1297 entity) {
		try {
			final Comparison comparison = data.get("comparison");

			return comparison.compare(
				ResourceCommand.obtainResourceValue(entity, data.get("left_resource")),
				ResourceCommand.obtainResourceValue(entity, data.get("right_resource"))
			);
		} catch (Exception e) {
			return false;
		}
    }

    public static ConditionFactory<class_1297> getFactory() {
        return new ConditionFactory<>(
            OriginsMath.identifier("compare_resources"),
            new SerializableData()
                .add("left_resource", ApoliDataTypes.POWER_TYPE)
                .add("comparison", ApoliDataTypes.COMPARISON)
                .add("right_resource", ApoliDataTypes.POWER_TYPE),
            CompareResourcesCondition::condition
        );
    }
}
