package io.github.xrickastley.originsmath.factories;

import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2378;
import net.minecraft.class_3545;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.actions.bientity.VariableExecuteCommandAction;

public class OriginsMathBientityActions {
	public static void register() {
		register(VariableExecuteCommandAction::getFactory);

		OriginsMath
			.sublogger(OriginsMathPowers.class)
			.info("Registered all base bi-entity actions!");
	}

	private static ActionFactory<class_3545<class_1297, class_1297>> register(Supplier<ActionFactory<class_3545<class_1297, class_1297>>> factorySupplier) {
		return register(factorySupplier.get());
	}

	private static ActionFactory<class_3545<class_1297, class_1297>> register(ActionFactory<class_3545<class_1297, class_1297>> actionFactory) {
		if (ApoliRegistries.BIENTITY_ACTION.method_10250(actionFactory.getSerializerId())) return ApoliRegistries.BIENTITY_ACTION.method_10223(actionFactory.getSerializerId());

		return class_2378.method_10230(ApoliRegistries.BIENTITY_ACTION, actionFactory.getSerializerId(), actionFactory);
	}
}
