package io.github.xrickastley.originsmath.factories;

import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.conditions.entity.*;
import net.minecraft.class_1297;
import net.minecraft.class_2378;

public class OriginsMathEntityConditions {
	public static void register() {
		register(CompareResourcesCondition.getFactory());
		register(EmptyResourceCondition.getFactory());
		register(FullResourceCondition.getFactory());

		OriginsMath
			.sublogger(OriginsMathPowers.class)
			.info("Registered all base entity conditions!");
	}

	private static ConditionFactory<class_1297> register(ConditionFactory<class_1297> conditionFactory) {
		if (ApoliRegistries.ENTITY_CONDITION.method_10250(conditionFactory.getSerializerId())) return ApoliRegistries.ENTITY_CONDITION.method_10223(conditionFactory.getSerializerId());

		return class_2378.method_10230(ApoliRegistries.ENTITY_CONDITION, conditionFactory.getSerializerId(), conditionFactory);
	}
	
}
