package io.github.xrickastley.originsmath.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.xrickastley.originsmath.powers.DamageDealtLinkedResourcePower;
import io.github.xrickastley.originsmath.powers.DamageTakenLinkedResourcePower;
import io.github.xrickastley.originsmath.powers.HealingLinkedResourcePower;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import com.llamalad7.mixinextras.sugar.Local;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
	public LivingEntityMixin(final class_1299<?> type, final class_1937 world) {
		super(type, world);

		throw new AssertionError();
	}

	@Inject(
		method = "applyDamage",
		at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/LivingEntity;getAbsorptionAmount()F",
			ordinal = 0
        )
	)
	private void updateDamageResourcePowers(class_1282 source, float amount, CallbackInfo ci, @Local(ordinal = 1) float finalDMG) {
		PowerHolderComponent
			.getPowers(source.method_5529(), DamageDealtLinkedResourcePower.class)
			.forEach(power -> power.setDamageData(source, finalDMG, this));

		PowerHolderComponent
			.getPowers(this, DamageTakenLinkedResourcePower.class)
			.forEach(power -> power.setDamageData(source, finalDMG));
	}

	@Inject(
		method = "heal",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/LivingEntity;setHealth(F)V",
			shift = At.Shift.BEFORE
		)
	)
	private void updateHealResourcePowers(float amount, CallbackInfo ci) {
		PowerHolderComponent
			.getPowers(this, HealingLinkedResourcePower.class)
			.forEach(power -> power.setHealingAmount(amount));
	}
}
