package io.github.xrickastley.originsmath.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.xrickastley.originsmath.powers.DamageDealtLinkedResourcePower;
import io.github.xrickastley.originsmath.powers.DamageTakenLinkedResourcePower;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
	public PlayerEntityMixin(final class_1937 world, final class_2338 pos, final float yaw, final GameProfile gameProfile) {
		super(class_1299.field_6097, world);

		throw new AssertionError();
	}

	@Inject(
		method = "applyDamage",
		at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/entity/player/PlayerEntity;getAbsorptionAmount()F",
			ordinal = 0
        )
	)
	private void updateDamageResourcePowers(class_1282 source, float amount, CallbackInfo ci, @Local(ordinal = 1) float finalDMG) {
		PowerHolderComponent
			.getPowers(source.method_5529(), DamageDealtLinkedResourcePower.class)
			.forEach(power -> power.setDamageData(source, finalDMG, this));

		PowerHolderComponent
			.getPowers(this, DamageTakenLinkedResourcePower.class)
			.forEach(power -> power.setDamageData(source, finalDMG));
	}
}
