package io.github.xrickastley.originsmath.powers;

import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_3545;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.util.InstanceValueSupplier;

/**
 * A resource who's value is based on the integer counterpart of an {@code EntityAttribute}.
 */
public class AttributeLinkedResourcePower extends SuppliedLinkedVariableIntPower<class_3545<class_1309, class_1320>> {
	private AttributeLinkedResourcePower(PowerType<?> type, class_1309 entity, class_1320 attribute, AttributeValue value) {
		super(type, entity, value, () -> new class_3545<class_1309,class_1320>(entity, attribute));
	}

	public static PowerFactory<?> createFactory() {
		return new PowerFactory<>(
			OriginsMath.identifier("attribute_linked_resource"),
			new SerializableData()
				.add("attribute", SerializableDataTypes.ATTRIBUTE)
				.add("value", AttributeLinkedResourcePower.ATTRIBUTE_VALUE, AttributeValue.TOTAL),
			data -> (powerType, livingEntity) -> new AttributeLinkedResourcePower(powerType, livingEntity, data.get("attribute"), data.get("value"))
		);
	}

	private static final SerializableDataType<AttributeValue> ATTRIBUTE_VALUE = SerializableDataType.enumValue(AttributeValue.class);

	private static enum AttributeValue implements InstanceValueSupplier<class_3545<class_1309, class_1320>> {
		BASE  (pair -> pair.method_15442().method_26826(pair.method_15441())),
		TOTAL (pair -> pair.method_15442().method_26825(pair.method_15441()));

		private final Function<class_3545<class_1309, class_1320>, Number> supplier;

		AttributeValue(Function<class_3545<class_1309, class_1320>, Number> supplier) {
			this.supplier = supplier;
		}

		public int supplyValue(class_3545<class_1309, class_1320> entityAndAttribute) {
			return supplier
				.apply(entityAndAttribute)
				.intValue();
		}

		public Number supplyAsNumber(class_3545<class_1309, class_1320> player) {
			return supplier.apply(player);
		}
	}
}
