package io.github.xrickastley.originsmath.powers;

import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1959;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.mixins.BiomeAccessor;
import io.github.xrickastley.originsmath.util.InstanceValueSupplier;

public class CurrentBiomeLinkedResourcePower extends SuppliedLinkedVariableIntPower<class_1959> {
	private CurrentBiomeLinkedResourcePower(PowerType<?> type, class_1309 entity, BiomeProperty property) {
		super(type, entity, property, () -> entity.method_37908().method_23753(entity.method_24515()).comp_349());
	}

	public static PowerFactory<?> createFactory() {
		return new PowerFactory<>(
			OriginsMath.identifier("current_biome_linked_resource"),
			new SerializableData()
				.add("property", CurrentBiomeLinkedResourcePower.BIOME_PROPERTY),
			data -> (powerType, livingEntity) -> new CurrentBiomeLinkedResourcePower(powerType, livingEntity, data.get("property"))
		);
	}

	private static final SerializableDataType<BiomeProperty> BIOME_PROPERTY = SerializableDataType.enumValue(BiomeProperty.class);

	private static enum BiomeProperty implements InstanceValueSupplier<class_1959> {
		TEMPERATURE		(biome -> biome.method_8712()),
		HUMIDITY		(biome -> ((BiomeAccessor)(Object) biome).getWeather().comp_846());

		private final Function<class_1959, Number> supplier;

		BiomeProperty(Function<class_1959, Number> supplier) {
			this.supplier = supplier;
		}

		public int supplyValue(class_1959 biome) {
			return supplier
				.apply(biome)
				.intValue();
		}

		public Number supplyAsNumber(class_1959 biome) {
			return supplier.apply(biome);
		}
	}
}
