package io.github.xrickastley.originsmath.powers;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsmath.OriginsMath;

public class DamageTakenLinkedResourcePower extends TimedLinkedVariableIntPower<class_3545<class_1282, Float>> {
	private final Predicate<class_3545<class_1282, Float>> damageCondition; 
	private final Consumer<class_3545<class_1297, class_1297>> bientityAction;

	private DamageTakenLinkedResourcePower(PowerType<?> type, class_1309 entity, int duration, Predicate<class_3545<class_1282, Float>> damageCondition, Consumer<class_3545<class_1297, class_1297>> bientityAction) {
		super(type, entity, duration, pair -> pair.method_15441());

		this.damageCondition = damageCondition;
		this.bientityAction = bientityAction;
	}

	/**
	 * Sets the damage data for this {@code DamageTakenLinkedResourcePower}. The damage data will 
	 * only be set if it fulfills the provided {@code damageCondition} for this {@code Power}.
	 * 
	 * Once the damage data is set, the associated {@code entityAction} with this power will be
	 * executed on the holder.
	 * 
	 * @param source The {@code DamageSource} of the damage dealt.
	 * @param amount The amount of damage dealt.
	 */
	public void setDamageData(class_1282 source, float amount) {
		final class_3545<class_1282,Float> damagePair = new class_3545<>(source, amount);

		if (damageCondition != null && !damageCondition.test(damagePair)) return;

		this.setTemporaryValue(damagePair);
		
		if (bientityAction != null) this.bientityAction.accept(new class_3545<>(this.entity, source.method_5529()));
	}

	public static PowerFactory<?> createFactory() {
		return new PowerFactory<>(
			OriginsMath.identifier("damage_taken_linked_resource"),
			new SerializableData()
				.add("duration", SerializableDataTypes.INT, Integer.MAX_VALUE)
				.add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null)
				.add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null),
			data -> (powerType, livingEntity) -> new DamageTakenLinkedResourcePower(
				powerType,
				livingEntity,
				data.getInt("duration"),
				data.get("damage_condition"),
				data.get("bientity_action")
			)
		);
	}
}
