package io.github.xrickastley.originsmath.powers;

import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.util.InstanceValueSupplier;

public class PlayerLinkedResourcePower extends SuppliedLinkedVariableIntPower<class_1657> {
	private PlayerLinkedResourcePower(PowerType<?> type, class_1309 entity, PlayerProperty property) {
		super(type, entity, property, () -> entity instanceof final class_1657 player ? player : null);
	}

	public static PowerFactory<?> createFactory() {
		return new PowerFactory<>(
			OriginsMath.identifier("player_linked_resource"),
			new SerializableData()
				.add("property", PlayerLinkedResourcePower.PLAYER_PROPERTY),
			data -> (powerType, livingEntity) -> new PlayerLinkedResourcePower(powerType, livingEntity, data.get("property"))
		);
	}

	private static final SerializableDataType<PlayerProperty> PLAYER_PROPERTY = SerializableDataType.enumValue(PlayerProperty.class);

	private static enum PlayerProperty implements InstanceValueSupplier<class_1657> {
		FOOD_LEVEL      (player -> player.method_7344().method_7586()),
		SATURATION      (player -> player.method_7344().method_7589()),
		HEALTH          (player -> player.method_6032()),
		RELATIVE_HEALTH (player -> player.method_6032() / player.method_6063()),
		ABSORPTION      (player -> player.method_6067()),
		BREATHING       (player -> player.method_5669()),
		FIRE_TICKS      (player -> player.method_20802()),
		FROZEN_TICKS    (player -> player.method_32312()),
		FREEZING_SCALE  (player -> player.method_32313()),
		EXP_LEVEL       (player -> player.field_7520),
		EXP_POINTS      (player -> player.field_7495),
		EXP_SCORE       (player -> player.method_7272()),
		SLEEP_TIMER     (player -> player.method_7297()),
		STUCK_ARROWS    (player -> player.method_6022()),
		FALL_DISTANCE   (player -> player.field_6017),
		TIME_OF_DAY     (player -> player.method_37908().method_8532() % 24000L),
		AGE				(player -> player.field_6012),
		X               (player -> player.method_23317()),
		Y               (player -> player.method_23318()),
		Z               (player -> player.method_23321()),
		VELOCITY_X      (player -> player.method_18798().method_10216()),
		VELOCITY_Y      (player -> player.method_18798().method_10214()),
		VELOCITY_Z      (player -> player.method_18798().method_10215()),
		PITCH           (player -> player.method_36455()),
		YAW             (player -> player.method_36454()),
		ROLL            (player -> player.method_6003());

		private final Function<class_1657, Number> supplier;

		PlayerProperty(Function<class_1657, Number> supplier) {
			this.supplier = supplier;
		}

		public int supplyValue(class_1657 player) {
			return supplier
				.apply(player)
				.intValue();
		}

		public Number supplyAsNumber(class_1657 player) {
			return supplier.apply(player);
		}
	}
}