package io.github.xrickastley.originsmath.powers;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsmath.OriginsMath;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_266;
import net.minecraft.class_269;

public class ScoreboardLinkedResourcePower extends LinkedVariableIntPower {
	private final String objective;

	private ScoreboardLinkedResourcePower(PowerType<?> type, class_1309 entity, String objective) {
		super(type, entity);

		this.objective = objective;
	}

	@Override
	protected int supplyValue() {
		final class_269 scoreboard = entity.method_37908().method_8428();
		final class_266 scObjective = scoreboard.method_1170(objective);
		final String name = ScoreboardLinkedResourcePower.getUuidOrNameString(entity);

		return scObjective == null || !scoreboard.method_1183(name, scObjective)
			? 0
			: scoreboard.method_1180(name, scObjective).method_1126();
	}

	@Override
	public double supplyDoubleValue() {
		return supplyValue();
	}

	private static String getUuidOrNameString(class_1297 entity) {
		return entity instanceof class_1657 playerEntity ? playerEntity.method_5820() : entity.method_5845();
	}

	public static PowerFactory<?> createFactory() {
		return new PowerFactory<>(
			OriginsMath.identifier("scoreboard_linked_resource"),
			new SerializableData()
				.add("objective", SerializableDataTypes.STRING),
			data -> (powerType, livingEntity) -> new ScoreboardLinkedResourcePower(powerType, livingEntity, data.getString("objective"))
		);
	}
}
