package io.github.xrickastley.originsmath.powers;

import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsmath.OriginsMath;
import io.github.xrickastley.originsmath.util.InstanceValueSupplier;

/**
 * A resource who's value is based on the integer counterpart of an {@code EntityAttribute}.
 */
public class StatusEffectLinkedResourcePower extends SuppliedLinkedVariableIntPower<class_1293> {
	private StatusEffectLinkedResourcePower(PowerType<?> type, class_1309 entity, class_1291 effect, StatusEffectProperty property) {
		super(type, entity, property, () -> entity.method_6112(effect));
	}

	public static PowerFactory<?> createFactory() {
		return new PowerFactory<>(
			OriginsMath.identifier("status_effect_linked_resource"),
			new SerializableData()
				.add("effect", SerializableDataTypes.STATUS_EFFECT)
				.add("property", StatusEffectLinkedResourcePower.STATUS_EFFECT_PROPERTY),
			data -> (powerType, livingEntity) -> new StatusEffectLinkedResourcePower(
				powerType, 
				livingEntity, 
				data.get("effect"), 
				data.get("property")
			)
		);
	}

	private static final SerializableDataType<StatusEffectProperty> STATUS_EFFECT_PROPERTY = SerializableDataType.enumValue(StatusEffectProperty.class);

	private static enum StatusEffectProperty implements InstanceValueSupplier<class_1293> {
		AMPLIFIER (instance -> instance != null ? instance.method_5578() : -1),
		DURATION  (instance -> instance != null ? instance.method_5584() : 0);

		private final Function<class_1293, Number> supplier;

		StatusEffectProperty(Function<class_1293, Number> supplier) {
			this.supplier = supplier;
		}

		public int supplyValue(class_1293 player) {
			return supplier
				.apply(player)
				.intValue();
		}

		public Number supplyAsNumber(class_1293 player) {
			return supplier.apply(player);
		}
	} 
}
