package io.github.xrickastley.originsmath.util;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2378;
import net.minecraft.class_4926.class_4932;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.modifier.IModifierOperation;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierOperation;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.xrickastley.originsmath.OriginsMath;

public enum OriginsMathModifierOperation implements IModifierOperation {
	STANDARD_MULTIPLY_BASE(
		Phase.BASE, 
		33, 
		(values, base, current) -> current * values.stream().reduce(0.0, Double::sum)
	),
	STANDARD_MULTIPLY_TOTAL(
		Phase.TOTAL,
		33,
		(values, base, current) -> current * values.stream().reduce(0.0, Double::sum)
	),
	STANDARD_DIVIDE_BASE(
		Phase.BASE,
		66,
		(values, base, current) -> current / values.stream().reduce(0.0, Double::sum)
	),
	STANDARD_DIVIDE_TOTAL(
		Phase.TOTAL,
		66,
		(values, base, current) -> current / values.stream().reduce(0.0, Double::sum)
	);

	private final Phase phase;
	private final int order;
	private final class_4932<List<Double>, Double, Double, Double> function;

	OriginsMathModifierOperation(Phase phase, int order, class_4932<List<Double>, Double, Double, Double> function) {
		this.phase = phase;
		this.order = order;
		this.function = function;
	}

	@Override
	public Phase getPhase() {
		return phase;
	}

	@Override
	public int getOrder() {
		return order;
	}

	@Override
	public SerializableData getData() {
		return ModifierOperation.DATA;
	}

	@Override
	public double apply(class_1297 entity, List<SerializableData.Instance> instances, double base, double current) {
		return function.apply(
			instances
				.stream()
				.map(instance -> {
					double value = 0;
					if (instance.isPresent("resource")) {
						PowerHolderComponent component = PowerHolderComponent.KEY.get(entity);
						PowerType<?> powerType = instance.get("resource");

						if (!component.hasPower(powerType)) {
							value = instance.get("value");
						} else {
							Power p = component.getPower(powerType);
							
							// Not using LinkedVariableIntPower to keep parity with the standard Modifier Operations.
							if (p instanceof VariableIntPower vip) value = vip.getValue();
							else if (p instanceof CooldownPower cp) value = cp.getRemainingTicks();
						}
					} else {
						value = instance.get("value");
					}

					if (instance.isPresent("modifier")) {
						List<Modifier> modifiers = instance.get("modifier");
						value = ModifierUtil.applyModifiers(entity, modifiers, value);
					}

					return value;
			})
			.collect(Collectors.toList()),
		base, current);
	}

	public static void register() {
		for (OriginsMathModifierOperation operation : OriginsMathModifierOperation.values()) {
			class_2378.method_10230(
				ApoliRegistries.MODIFIER_OPERATION,
				OriginsMath.identifier(operation.toString().toLowerCase(Locale.ROOT)),
				operation
			);
		}	
	}
}
