/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.command;

import dev.xhyrom.brigo.client.ISuggestionProvider;
import dev.xhyrom.brigo.command.CommandSource;
import dev.xhyrom.brigo.shadow.brigadier.builder.ArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.builder.RequiredArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.tree.CommandNode;
import dev.xhyrom.brigo.util.SuggestionProviders;
import java.util.Map;

public class CommandTreeConverter {
    private final Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> nodeMapping;
    private final CommandSource source;

    public CommandTreeConverter(Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> nodeMapping, CommandSource source) {
        this.nodeMapping = nodeMapping;
        this.source = source;
    }

    public void convertChildren(CommandNode<CommandSource> serverNode, CommandNode<ISuggestionProvider> clientNode) {
        for (CommandNode<CommandSource> child : serverNode.getChildren()) {
            if (!child.canUse(this.source)) continue;
            CommandNode<ISuggestionProvider> convertedChild = this.convertNode(child);
            this.nodeMapping.put(child, convertedChild);
            clientNode.addChild(convertedChild);
            this.convertChildren(child, convertedChild);
        }
    }

    private CommandNode<ISuggestionProvider> convertNode(CommandNode<CommandSource> serverNode) {
        ArgumentBuilder<CommandSource, ?> builder = serverNode.createBuilder();
        return this.configureBuilder(builder, serverNode).build();
    }

    private ArgumentBuilder<ISuggestionProvider, ?> configureBuilder(ArgumentBuilder<ISuggestionProvider, ?> builder, CommandNode<CommandSource> serverNode) {
        builder.requires(client -> true);
        if (builder.getCommand() != null) {
            builder.executes(context -> 0);
        }
        if (builder instanceof RequiredArgumentBuilder) {
            this.configureArgumentBuilder((RequiredArgumentBuilder)builder);
        }
        if (builder.getRedirect() != null) {
            builder.redirect(this.nodeMapping.get(builder.getRedirect()));
        }
        return builder;
    }

    private void configureArgumentBuilder(RequiredArgumentBuilder<ISuggestionProvider, ?> builder) {
        if (builder.getSuggestionsProvider() != null) {
            builder.suggests(SuggestionProviders.safelySwap(builder.getSuggestionsProvider()));
        } else {
            builder.suggests(SuggestionProviders.ASK_SERVER);
        }
    }
}

