/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.command.serialization;

import com.google.common.collect.Maps;
import dev.xhyrom.brigo.command.serialization.ArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.DoubleArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.EmptyArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.FloatArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.IntegerArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.LongArgumentSerializer;
import dev.xhyrom.brigo.command.serialization.serializers.StringArgumentSerializer;
import dev.xhyrom.brigo.shadow.brigadier.arguments.ArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.arguments.BoolArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.arguments.DoubleArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.arguments.FloatArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.arguments.IntegerArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.arguments.LongArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.arguments.StringArgumentType;
import java.util.Map;
import net.minecraft.class_1653;
import net.minecraft.class_1967;
import org.jetbrains.annotations.Nullable;

public class ArgumentTypes {
    private static final Map<Class<?>, Entry<?>> BY_CLASS = Maps.newHashMap();
    private static final Map<class_1653, Entry<?>> BY_NAME = Maps.newHashMap();

    public static <T extends ArgumentType<?>> void register(String pName, Class<T> pClazz, ArgumentSerializer<T> pSerializer) {
        class_1653 resourcelocation = new class_1653(pName);
        if (BY_CLASS.containsKey(pClazz)) {
            throw new IllegalArgumentException("Class " + pClazz.getName() + " already has a serializer!");
        }
        if (BY_NAME.containsKey(resourcelocation)) {
            throw new IllegalArgumentException("'" + resourcelocation + "' is already a registered serializer!");
        }
        Entry<T> entry = new Entry<T>(pClazz, pSerializer, resourcelocation);
        BY_CLASS.put(pClazz, entry);
        BY_NAME.put(resourcelocation, entry);
    }

    public static void init() {
        ArgumentTypes.register("brigadier:bool", BoolArgumentType.class, new EmptyArgumentSerializer<BoolArgumentType>(BoolArgumentType::bool));
        ArgumentTypes.register("brigadier:float", FloatArgumentType.class, new FloatArgumentSerializer());
        ArgumentTypes.register("brigadier:double", DoubleArgumentType.class, new DoubleArgumentSerializer());
        ArgumentTypes.register("brigadier:integer", IntegerArgumentType.class, new IntegerArgumentSerializer());
        ArgumentTypes.register("brigadier:long", LongArgumentType.class, new LongArgumentSerializer());
        ArgumentTypes.register("brigadier:string", StringArgumentType.class, new StringArgumentSerializer());
    }

    @Nullable
    private static Entry<?> get(class_1653 pType) {
        return BY_NAME.get(pType);
    }

    @Nullable
    private static Entry<?> get(ArgumentType<?> pType) {
        return BY_CLASS.get(pType.getClass());
    }

    public static <T extends ArgumentType<?>> void serialize(class_1967 pBuffer, T pType) {
        Entry<?> entry = ArgumentTypes.get(pType);
        if (entry == null) {
            pBuffer.method_14780(new class_1653(""));
        } else {
            pBuffer.method_14780(entry.name);
            entry.serializer.serializeToNetwork(pType, pBuffer);
        }
    }

    @Nullable
    public static ArgumentType<?> deserialize(class_1967 pBuffer) {
        class_1653 resourcelocation = pBuffer.method_14781();
        Entry<?> entry = ArgumentTypes.get(resourcelocation);
        if (entry == null) {
            return null;
        }
        return entry.serializer.deserializeFromNetwork(pBuffer);
    }

    static class Entry<T extends ArgumentType<?>> {
        public final Class<T> clazz;
        public final ArgumentSerializer<T> serializer;
        public final class_1653 name;

        Entry(Class<T> pClazz, ArgumentSerializer<T> pSerializer, class_1653 pName) {
            this.clazz = pClazz;
            this.serializer = pSerializer;
            this.name = pName;
        }
    }
}

