/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.mixin.client;

import dev.xhyrom.brigo.accessor.NetHandlerPlayClientExtras;
import dev.xhyrom.brigo.client.ClientSuggestionProvider;
import dev.xhyrom.brigo.client.ISuggestionProvider;
import dev.xhyrom.brigo.client.network.CommandsPacket;
import dev.xhyrom.brigo.shadow.brigadier.CommandDispatcher;
import dev.xhyrom.brigo.shadow.brigadier.arguments.StringArgumentType;
import dev.xhyrom.brigo.shadow.brigadier.builder.LiteralArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.builder.RequiredArgumentBuilder;
import dev.xhyrom.brigo.shadow.brigadier.context.StringRange;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestion;
import dev.xhyrom.brigo.shadow.brigadier.suggestion.Suggestions;
import dev.xhyrom.brigo.util.SuggestionProviders;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1600;
import net.minecraft.class_1845;
import net.minecraft.class_2006;
import net.minecraft.class_2015;
import net.minecraft.class_2017;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1845.class})
public class NetHandlerPlayClientMixin
implements NetHandlerPlayClientExtras {
    @Shadow
    private class_1600 field_7915;
    @Unique
    private ClientSuggestionProvider brigo$suggestionsProvider;
    @Unique
    private CommandDispatcher<ISuggestionProvider> brigo$commands = new CommandDispatcher();
    @Unique
    private boolean brigo$entityStatusReceived = false;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.brigo$suggestionsProvider = new ClientSuggestionProvider((class_1845)this, this.field_7915);
    }

    @Inject(method={"handleTabComplete"}, at={@At(value="TAIL")})
    private void handleTabComplete(class_2006 packetIn, CallbackInfo ci) {
        String command = ClientSuggestionProvider.command;
        String[] matches = packetIn.method_7701();
        int lastSpace = command.lastIndexOf(32);
        int replaceStart = lastSpace == -1 ? 0 : lastSpace + 1;
        int replaceEnd = command.length();
        StringRange replacementRange = StringRange.between(replaceStart, replaceEnd);
        List<Suggestion> suggestions = Arrays.stream(matches).map(match -> new Suggestion(replacementRange, (String)match)).collect(Collectors.toList());
        this.brigo$suggestionsProvider.completeCustomSuggestions(new Suggestions(replacementRange, suggestions));
    }

    @Inject(method={"handleCustomPayload"}, at={@At(value="TAIL")})
    private void handleCustomPayload(class_2015 packetIn, CallbackInfo ci) {
        if (!packetIn.method_7733().equals("brigo:commands")) {
            return;
        }
        this.brigo$commands = new CommandDispatcher<ISuggestionProvider>(CommandsPacket.read(packetIn.method_7734()));
    }

    @Inject(method={"handleEntityStatus"}, at={@At(value="TAIL")})
    private void handleEntityStatus(class_2017 packetIn, CallbackInfo ci) {
        if (!this.brigo$commands.getRoot().getChildren().isEmpty() || this.brigo$entityStatusReceived) {
            return;
        }
        this.brigo$entityStatusReceived = true;
        this.brigo$suggestionsProvider().getSuggestionsFromServer().thenAccept(commands -> {
            for (Suggestion suggestion : commands.getList()) {
                this.brigo$commands.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(suggestion.getText().substring(1)).then(RequiredArgumentBuilder.argument("params", StringArgumentType.greedyString()).suggests(SuggestionProviders.ASK_SERVER)));
            }
        });
    }

    @Override
    @Unique
    public ClientSuggestionProvider brigo$suggestionsProvider() {
        return this.brigo$suggestionsProvider;
    }

    @Override
    @Unique
    @NotNull
    public CommandDispatcher<ISuggestionProvider> brigo$commands() {
        return this.brigo$commands;
    }
}

