/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.core;

import dev.xhyrom.brigo.shadow.tinylog.Level;
import dev.xhyrom.brigo.shadow.tinylog.core.ConfigurationParser;
import dev.xhyrom.brigo.shadow.tinylog.core.LogEntry;
import dev.xhyrom.brigo.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.brigo.shadow.tinylog.core.TinylogContextProvider;
import dev.xhyrom.brigo.shadow.tinylog.core.TinylogLoggingConfiguration;
import dev.xhyrom.brigo.shadow.tinylog.core.WritingThread;
import dev.xhyrom.brigo.shadow.tinylog.format.MessageFormatter;
import dev.xhyrom.brigo.shadow.tinylog.provider.ContextProvider;
import dev.xhyrom.brigo.shadow.tinylog.provider.InternalLogger;
import dev.xhyrom.brigo.shadow.tinylog.provider.LoggingProvider;
import dev.xhyrom.brigo.shadow.tinylog.runtime.RuntimeProvider;
import dev.xhyrom.brigo.shadow.tinylog.writers.Writer;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TinylogLoggingProvider
implements LoggingProvider {
    private final ContextProvider context;
    private final Level globalLevel;
    private final Map<String, Level> customLevels;
    private final List<String> knownTags;
    private final Collection<Writer>[][] writers;
    private final Collection<LogEntryValue>[][] requiredLogEntryValues;
    private final BitSet fullStackTraceRequired;
    private final WritingThread writingThread;

    public TinylogLoggingProvider() {
        this(new TinylogContextProvider());
    }

    protected TinylogLoggingProvider(ContextProvider contextProvider) {
        TinylogLoggingConfiguration config = new TinylogLoggingConfiguration();
        this.context = contextProvider;
        this.globalLevel = ConfigurationParser.getGlobalLevel();
        this.customLevels = ConfigurationParser.getCustomLevels();
        this.knownTags = ConfigurationParser.getTags();
        Level minimumLevel = config.calculateMinimumLevel(this.globalLevel, this.customLevels);
        boolean hasWritingThread = ConfigurationParser.isWritingThreadEnabled();
        this.writers = config.createWriters(this.knownTags, minimumLevel, hasWritingThread);
        this.requiredLogEntryValues = config.calculateRequiredLogEntryValues(this.writers);
        this.fullStackTraceRequired = config.calculateFullStackTraceRequirements(this.requiredLogEntryValues);
        WritingThread writingThread = this.writingThread = hasWritingThread ? config.createWritingThread(this.writers) : null;
        if (ConfigurationParser.isAutoShutdownEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        TinylogLoggingProvider.this.shutdown();
                    }
                    catch (InterruptedException ex) {
                        InternalLogger.log(Level.ERROR, ex, "Interrupted while waiting for shutdown");
                    }
                }
            });
        }
    }

    @Override
    public ContextProvider getContextProvider() {
        return this.context;
    }

    @Override
    public Level getMinimumLevel() {
        Level level = Level.OFF;
        for (int tagIndex = 0; tagIndex < this.writers.length; ++tagIndex) {
            for (int levelIndex = Level.TRACE.ordinal(); levelIndex < level.ordinal(); ++levelIndex) {
                if (this.writers[tagIndex][levelIndex].isEmpty()) continue;
                level = Level.values()[levelIndex];
            }
        }
        return level;
    }

    @Override
    public Level getMinimumLevel(String tag) {
        int tagIndex = this.getTagIndex(tag);
        for (int levelIndex = Level.TRACE.ordinal(); levelIndex < Level.OFF.ordinal(); ++levelIndex) {
            if (this.writers[tagIndex][levelIndex].isEmpty()) continue;
            return Level.values()[levelIndex];
        }
        return Level.OFF;
    }

    @Override
    public boolean isEnabled(int depth, String tag, Level level) {
        return this.isLoggable(RuntimeProvider.getCallerClassName(depth + 1), level, tag);
    }

    @Override
    public boolean isEnabled(String loggerClassName, String tag, Level level) {
        return this.isLoggable(RuntimeProvider.getCallerClassName(loggerClassName), level, tag);
    }

    private boolean isLoggable(String callerClassName, Level level, String tag) {
        Level activeLevel = this.customLevels.isEmpty() ? this.globalLevel : this.getLevel(callerClassName);
        return activeLevel.ordinal() <= level.ordinal() && !this.writers[this.getTagIndex(tag)][level.ordinal()].isEmpty();
    }

    @Override
    public void log(int depth, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        Level activeLevel;
        int tagIndex = this.getTagIndex(tag);
        StackTraceElement stackTraceElement = this.fullStackTraceRequired.get(tagIndex) ? RuntimeProvider.getCallerStackTraceElement(depth + 1) : null;
        if (this.customLevels.isEmpty()) {
            if (stackTraceElement == null && this.requiredLogEntryValues[tagIndex][level.ordinal()].contains((Object)LogEntryValue.CLASS)) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName(depth + 1), "<unknown>", null, -1);
            }
            activeLevel = this.globalLevel;
        } else {
            if (stackTraceElement == null) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName(depth + 1), "<unknown>", null, -1);
            }
            activeLevel = this.getLevel(stackTraceElement.getClassName());
        }
        if (activeLevel.ordinal() <= level.ordinal()) {
            LogEntry logEntry = TinylogLoggingConfiguration.createLogEntry(stackTraceElement, tag, level, exception, formatter, obj, arguments, this.requiredLogEntryValues[tagIndex], this.context);
            this.output(logEntry, this.writers[tagIndex][logEntry.getLevel().ordinal()]);
        }
    }

    @Override
    public void log(String loggerClassName, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object ... arguments) {
        Level activeLevel;
        int tagIndex = this.getTagIndex(tag);
        StackTraceElement stackTraceElement = this.fullStackTraceRequired.get(tagIndex) ? RuntimeProvider.getCallerStackTraceElement(loggerClassName) : null;
        if (this.customLevels.isEmpty()) {
            if (stackTraceElement == null && this.requiredLogEntryValues[tagIndex][level.ordinal()].contains((Object)LogEntryValue.CLASS)) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName(loggerClassName), "<unknown>", null, -1);
            }
            activeLevel = this.globalLevel;
        } else {
            if (stackTraceElement == null) {
                stackTraceElement = new StackTraceElement(RuntimeProvider.getCallerClassName(loggerClassName), "<unknown>", null, -1);
            }
            activeLevel = this.getLevel(stackTraceElement.getClassName());
        }
        if (activeLevel.ordinal() <= level.ordinal()) {
            LogEntry logEntry = TinylogLoggingConfiguration.createLogEntry(stackTraceElement, tag, level, exception, formatter, obj, arguments, this.requiredLogEntryValues[tagIndex], this.context);
            this.output(logEntry, this.writers[tagIndex][logEntry.getLevel().ordinal()]);
        }
    }

    @Override
    public void shutdown() throws InterruptedException {
        if (this.writingThread == null) {
            for (Writer writer : TinylogLoggingConfiguration.getAllWriters(this.writers)) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    InternalLogger.log(Level.ERROR, ex, "Failed to close writer");
                }
            }
        } else {
            this.writingThread.shutdown();
            this.writingThread.join();
        }
    }

    private int getTagIndex(String tag) {
        if (tag == null) {
            return 0;
        }
        int index = this.knownTags.indexOf(tag);
        return index == -1 ? this.knownTags.size() + 1 : index + 1;
    }

    private Level getLevel(String className) {
        Level customLevel;
        String key = className;
        while ((customLevel = this.customLevels.get(key)) == null) {
            int index = key.lastIndexOf(46);
            if (index == -1) {
                return this.globalLevel;
            }
            key = key.substring(0, index);
        }
        return customLevel;
    }

    private void output(LogEntry logEntry, Iterable<Writer> writers) {
        if (this.writingThread == null) {
            for (Writer writer : writers) {
                try {
                    writer.write(logEntry);
                }
                catch (Exception ex) {
                    InternalLogger.log(Level.ERROR, ex, "Failed to write log entry '" + logEntry.getMessage() + "'");
                }
            }
        } else {
            for (Writer writer : writers) {
                this.writingThread.add(writer, logEntry);
            }
        }
    }

    public Collection<Writer> getWriters(String tag, Level level) {
        HashSet<Writer> collectedWriters = new HashSet<Writer>();
        int tagIndex = this.getTagIndex(tag);
        if (tagIndex > this.knownTags.size() || level == Level.OFF) {
            return collectedWriters;
        }
        collectedWriters.addAll(this.writers[tagIndex][level.ordinal()]);
        return collectedWriters;
    }

    public Collection<Writer> getWriters(String tag) {
        HashSet<Writer> collectedWriters = new HashSet<Writer>();
        int tagIndex = this.getTagIndex(tag);
        if (tagIndex > this.knownTags.size()) {
            return collectedWriters;
        }
        for (int j = 0; j < this.writers[tagIndex].length; ++j) {
            collectedWriters.addAll(this.writers[tagIndex][j]);
        }
        return collectedWriters;
    }

    public Collection<Writer> getWriters() {
        HashSet<Writer> collectedWriters = new HashSet<Writer>();
        for (int tagIndex = 0; tagIndex < this.writers.length; ++tagIndex) {
            for (int levelIndex = 0; levelIndex < this.writers[tagIndex].length; ++levelIndex) {
                collectedWriters.addAll(this.writers[tagIndex][levelIndex]);
            }
        }
        return collectedWriters;
    }
}

