/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.pattern;

import dev.xhyrom.brigo.shadow.tinylog.Level;
import dev.xhyrom.brigo.shadow.tinylog.configuration.ServiceLoader;
import dev.xhyrom.brigo.shadow.tinylog.pattern.BundleToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.DateToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.ExceptionToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.FileNameToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.FullClassNameToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.IndentationToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.LineNumberToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.LoggerTagToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.MaximumSizeToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.MessageAndExceptionToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.MessageToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.MethodNameToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.MinimumSizeToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.PackageNameToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.PlainTextToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.ProcessIdToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.SeverityLevelIntegerToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.SeverityLevelToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.SimpleClassNameToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.SizeToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.ThreadContextToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.ThreadIdToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.ThreadNameToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.TimestampToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.Token;
import dev.xhyrom.brigo.shadow.tinylog.pattern.UptimeToken;
import dev.xhyrom.brigo.shadow.tinylog.provider.InternalLogger;
import dev.xhyrom.brigo.shadow.tinylog.throwable.ThrowableFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class FormatPatternParser {
    private static final Pattern SPLIT_PATTERN = Pattern.compile(",");
    private final List<ThrowableFilter> filters;

    public FormatPatternParser(String filters) {
        this.filters = filters == null ? Collections.emptyList() : new ServiceLoader<ThrowableFilter>(ThrowableFilter.class, String.class).createList(filters);
    }

    public Token parse(String pattern) {
        int splitIndex;
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        int count = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            char character = pattern.charAt(i);
            if (character == '{') {
                if (count == 0) {
                    if (start < i) {
                        tokens.add(new PlainTextToken(pattern.substring(start, i)));
                    }
                    start = i;
                }
                ++count;
                continue;
            }
            if (character != '}') continue;
            if (count == 0) {
                InternalLogger.log(Level.ERROR, "Opening curly bracket is missing: '" + pattern + "'");
                continue;
            }
            if (--count != 0) continue;
            tokens.add(this.parse(pattern.substring(start + 1, i)));
            start = i + 1;
        }
        if (count > 0) {
            InternalLogger.log(Level.ERROR, "Closing curly bracket is missing: '" + pattern + "'");
        }
        if ((splitIndex = pattern.indexOf(124, start)) == -1) {
            tokens.add(this.createPlainToken(pattern.substring(start)));
            return tokens.size() == 1 ? (Token)tokens.get(0) : new BundleToken(tokens);
        }
        String token = pattern.substring(start, splitIndex).trim();
        tokens.add(this.createPlainToken(token));
        String[] styleOptions = SPLIT_PATTERN.split(pattern.substring(splitIndex + 1));
        return FormatPatternParser.styleToken(tokens.size() == 1 ? (Token)tokens.get(0) : new BundleToken(tokens), styleOptions);
    }

    private Token createPlainToken(String placeholder) {
        Token token;
        int splitIndex = placeholder.indexOf(58);
        if (splitIndex == -1) {
            token = this.createPlainToken(placeholder.trim(), null);
        } else {
            String name = placeholder.substring(0, splitIndex).trim();
            String configuration = placeholder.substring(splitIndex + 1).trim();
            token = this.createPlainToken(name, configuration);
        }
        return token == null ? new PlainTextToken(placeholder) : token;
    }

    private Token createPlainToken(String name, String configuration) {
        if (name.equals("date")) {
            return FormatPatternParser.createDateToken(configuration);
        }
        if ("timestamp".equals(name)) {
            return new TimestampToken(configuration);
        }
        if ("uptime".equals(name)) {
            return configuration == null ? new UptimeToken() : new UptimeToken(configuration);
        }
        if ("pid".equals(name)) {
            return new ProcessIdToken();
        }
        if ("thread".equals(name)) {
            return new ThreadNameToken();
        }
        if ("thread-id".equals(name)) {
            return new ThreadIdToken();
        }
        if ("context".equals(name)) {
            return FormatPatternParser.createThreadContextToken(configuration);
        }
        if ("class".equals(name)) {
            return new FullClassNameToken();
        }
        if ("class-name".equals(name)) {
            return new SimpleClassNameToken();
        }
        if ("package".equals(name)) {
            return new PackageNameToken();
        }
        if ("method".equals(name)) {
            return new MethodNameToken();
        }
        if ("file".equals(name)) {
            return new FileNameToken();
        }
        if ("line".equals(name)) {
            return new LineNumberToken();
        }
        if ("tag".equals(name)) {
            return configuration == null ? new LoggerTagToken() : new LoggerTagToken(configuration);
        }
        if ("level".equals(name)) {
            return new SeverityLevelToken();
        }
        if ("level-code".equals(name)) {
            return new SeverityLevelIntegerToken();
        }
        if ("message".equals(name)) {
            return new MessageAndExceptionToken(this.filters);
        }
        if ("message-only".equals(name)) {
            return new MessageToken();
        }
        if ("exception".equals(name)) {
            return new ExceptionToken(this.filters);
        }
        if ("opening-curly-bracket".equals(name)) {
            return new PlainTextToken("{");
        }
        if ("closing-curly-bracket".equals(name)) {
            return new PlainTextToken("}");
        }
        if ("pipe".equals(name)) {
            return new PlainTextToken("|");
        }
        return null;
    }

    private static Token createDateToken(String configuration) {
        if (configuration == null) {
            return new DateToken();
        }
        try {
            return new DateToken(configuration);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.ERROR, "'" + configuration + "' is an invalid date format pattern");
            return new DateToken();
        }
    }

    private static Token createThreadContextToken(String configuration) {
        String key;
        if (configuration == null) {
            InternalLogger.log(Level.ERROR, "\"{context}\" requires a key");
            return new PlainTextToken("");
        }
        int splitIndex = configuration.indexOf(44);
        String string = key = splitIndex == -1 ? configuration.trim() : configuration.substring(0, splitIndex).trim();
        if (key.isEmpty()) {
            InternalLogger.log(Level.ERROR, "\"{context}\" requires a key");
            return new PlainTextToken("");
        }
        String defaultValue = splitIndex == -1 ? null : configuration.substring(splitIndex + 1).trim();
        return defaultValue == null ? new ThreadContextToken(key) : new ThreadContextToken(key, defaultValue);
    }

    private static Token styleToken(Token token, String[] options) {
        Token styledToken = token;
        for (String option : options) {
            int number;
            int splitIndex = option.indexOf(61);
            if (splitIndex == -1) {
                InternalLogger.log(Level.ERROR, "No value set for '" + option.trim() + "'");
                continue;
            }
            String key = option.substring(0, splitIndex).trim();
            String value = option.substring(splitIndex + 1).trim();
            try {
                number = FormatPatternParser.parsePositiveInteger(value);
            }
            catch (NumberFormatException ex) {
                InternalLogger.log(Level.ERROR, "'" + value + "' is an invalid value for '" + key + "'");
                continue;
            }
            if ("min-size".equals(key)) {
                styledToken = new MinimumSizeToken(styledToken, number);
                continue;
            }
            if ("max-size".equals(key)) {
                styledToken = new MaximumSizeToken(styledToken, number);
                continue;
            }
            if ("size".equals(key)) {
                styledToken = new SizeToken(styledToken, number);
                continue;
            }
            if ("indent".equals(key)) {
                styledToken = new IndentationToken(styledToken, number);
                continue;
            }
            InternalLogger.log(Level.ERROR, "Unknown style option: '" + key + "'");
        }
        return styledToken;
    }

    private static int parsePositiveInteger(String value) throws NumberFormatException {
        int number = Integer.parseInt(value);
        if (number >= 0) {
            return number;
        }
        throw new NumberFormatException();
    }
}

