/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.pattern;

import dev.xhyrom.brigo.shadow.tinylog.core.LogEntry;
import dev.xhyrom.brigo.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.brigo.shadow.tinylog.pattern.ExceptionToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.MessageToken;
import dev.xhyrom.brigo.shadow.tinylog.pattern.Token;
import dev.xhyrom.brigo.shadow.tinylog.throwable.ThrowableFilter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

final class MessageAndExceptionToken
implements Token {
    private final MessageToken messageToken = new MessageToken();
    private final ExceptionToken exceptionToken;

    MessageAndExceptionToken(List<ThrowableFilter> filters) {
        this.exceptionToken = new ExceptionToken(filters);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return EnumSet.of(LogEntryValue.MESSAGE, LogEntryValue.EXCEPTION);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        this.messageToken.render(logEntry, builder);
        if (logEntry.getException() != null) {
            if (logEntry.getMessage() != null) {
                builder.append(": ");
            }
            this.exceptionToken.render(logEntry, builder);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        if (logEntry.getException() == null) {
            statement.setString(index, logEntry.getMessage());
        } else {
            StringBuilder builder = new StringBuilder();
            this.render(logEntry, builder);
            statement.setString(index, builder.toString());
        }
    }
}

