/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.brigo.shadow.tinylog.provider;

import dev.xhyrom.brigo.shadow.tinylog.Level;

public final class InternalLogger {
    private static final int BUFFER_SIZE = 256;

    private InternalLogger() {
    }

    public static void log(Level level, String message) {
        System.err.println("LOGGER " + (Object)((Object)level) + ": " + message);
    }

    public static void log(Level level, Throwable exception) {
        String nameOfException = exception.getClass().getName();
        String messageOfException = exception.getMessage();
        if (messageOfException == null || messageOfException.isEmpty()) {
            System.err.println("LOGGER " + (Object)((Object)level) + ": " + nameOfException);
        } else {
            System.err.println("LOGGER " + (Object)((Object)level) + ": " + messageOfException + " (" + nameOfException + ")");
        }
    }

    public static void log(Level level, Throwable exception, String message) {
        String nameOfException = exception.getClass().getName();
        String messageOfException = exception.getMessage();
        StringBuilder builder = new StringBuilder(256);
        builder.append("LOGGER ");
        builder.append((Object)level);
        builder.append(": ");
        builder.append(message);
        builder.append(" (");
        builder.append(nameOfException);
        if (messageOfException != null && !messageOfException.isEmpty()) {
            builder.append(": ");
            builder.append(messageOfException);
        }
        builder.append(")");
        System.err.println(builder);
    }
}

