/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.stickerframes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrbysco.stickerframes.client.state.StickerFrameRenderState;
import com.mrbysco.stickerframes.entity.StickerFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BlockStateDefinitions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class StickerFrameRenderer<T extends StickerFrame>
extends EntityRenderer<T, StickerFrameRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final MapRenderer mapRenderer;
    private final BlockRenderDispatcher blockRenderer;

    public StickerFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
        this.mapRenderer = context.getMapRenderer();
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    protected int getBlockLightLevel(T stickerFrame, BlockPos pos) {
        return ((StickerFrame)((Object)stickerFrame)).isGlowing() ? Math.max(5, super.getBlockLightLevel(stickerFrame, pos)) : super.getBlockLightLevel(stickerFrame, pos);
    }

    public void submit(StickerFrameRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        float f1;
        float f;
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
        poseStack.pushPose();
        Direction direction = renderState.direction;
        Vec3 vec3 = this.getRenderOffset(renderState);
        poseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
        poseStack.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        if (direction.getAxis().isHorizontal()) {
            f = 0.0f;
            f1 = 180.0f - direction.toYRot();
        } else {
            f = -90 * direction.getAxisDirection().getStep();
            f1 = 180.0f;
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f1));
        if (!renderState.isInvisible) {
            BlockState blockstate = BlockStateDefinitions.getItemFrameFakeState((boolean)renderState.isGlowFrame, (renderState.mapId != null ? 1 : 0) != 0);
            BlockStateModel blockstatemodel = this.blockRenderer.getBlockModel(blockstate);
            poseStack.pushPose();
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            nodeCollector.submitBlockModel(poseStack, RenderType.entitySolidZOffsetForward((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), blockstatemodel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
            poseStack.popPose();
        }
        if (renderState.isInvisible) {
            poseStack.translate(0.0f, 0.0f, 0.5f);
        } else {
            poseStack.translate(0.0f, 0.0f, 0.4375f);
        }
        if (renderState.mapId != null) {
            int j = renderState.rotation % 4 * 2;
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)j * 360.0f / 8.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            poseStack.scale(0.0078125f, 0.0078125f, 0.0078125f);
            poseStack.translate(-64.0f, -64.0f, 0.0f);
            poseStack.translate(0.0f, 0.0f, -1.0f);
            int lightCoords = this.getLightCoords(renderState.isGlowFrame, 15728850, renderState.lightCoords);
            this.mapRenderer.render(renderState.mapRenderState, poseStack, nodeCollector, true, lightCoords);
        } else if (!renderState.item.isEmpty()) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)renderState.rotation * 360.0f / 8.0f));
            int lightCoords = this.getLightCoords(renderState.isGlowFrame, 0xF000F0, renderState.lightCoords);
            poseStack.scale(0.5f, 0.5f, 0.001f);
            if (renderState.displayContext == ItemDisplayContext.GUI) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            }
            renderState.item.submit(poseStack, nodeCollector, lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor);
        }
        poseStack.popPose();
    }

    private int getLightCoords(boolean isGlowFrame, int glowLight, int normalLight) {
        return isGlowFrame ? glowLight : normalLight;
    }

    public Vec3 getRenderOffset(StickerFrameRenderState renderState) {
        return new Vec3((double)((float)renderState.direction.getStepX() * 0.3f), -0.25, (double)((float)renderState.direction.getStepZ() * 0.3f));
    }

    protected boolean shouldShowName(T entity, double distanceToCameraSq) {
        return Minecraft.renderNames() && this.entityRenderDispatcher.crosshairPickEntity == entity && entity.getItem().getCustomName() != null;
    }

    public StickerFrameRenderState createRenderState() {
        return new StickerFrameRenderState();
    }

    public void extractRenderState(T frame, StickerFrameRenderState renderState, float partialTick) {
        MapItemSavedData mapitemsaveddata;
        MapId mapid;
        super.extractRenderState(frame, (EntityRenderState)renderState, partialTick);
        renderState.direction = frame.getDirection();
        ItemStack itemstack = frame.getItem();
        renderState.displayContext = ((StickerFrame)((Object)frame)).usesGuiDisplay() ? ItemDisplayContext.GUI : ItemDisplayContext.FIXED;
        this.itemModelResolver.updateForNonLiving(renderState.item, itemstack, renderState.displayContext, frame);
        renderState.rotation = frame.getRotation();
        renderState.isGlowFrame = ((StickerFrame)((Object)frame)).isGlowing();
        renderState.mapId = null;
        if (!itemstack.isEmpty() && (mapid = frame.getFramedMapId(itemstack)) != null && (mapitemsaveddata = MapItem.getSavedData((ItemStack)itemstack, (Level)frame.level())) != null) {
            this.mapRenderer.extractRenderState(mapid, mapitemsaveddata, renderState.mapRenderState);
            renderState.mapId = mapid;
        }
    }
}

