/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.stickerframes.data;

import com.mrbysco.stickerframes.registry.FrameEnchantments;
import com.mrbysco.stickerframes.registry.FrameRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.EnchantmentTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber
public class FrameDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new StickerRecipes.Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new StickerEnchantmentTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new StickerDatapack(packOutput, event.getLookupProvider(), Set.of("stickerframes")));
        generator.addProvider(true, (DataProvider)new StickerLanguage(packOutput));
        generator.addProvider(true, (DataProvider)new StickerModels(packOutput));
    }

    private static class StickerRecipes
    extends RecipeProvider {
        public StickerRecipes(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            super(provider, recipeOutput);
        }

        protected void buildRecipes() {
            this.shaped(RecipeCategory.DECORATIONS, (ItemLike)FrameRegistry.STICKER_FRAME_ITEM.get()).pattern("XXX").pattern("XFX").pattern("XXX").define(Character.valueOf('X'), Ingredient.of(this.tagSet((TagKey<Item>)Tags.Items.RODS_WOODEN))).define(Character.valueOf('F'), (ItemLike)Items.PAINTING).unlockedBy("has_painting", this.has((ItemLike)Items.PAINTING)).save(this.output);
            this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)FrameRegistry.GLOW_STICKER_FRAME_ITEM.get()).requires((ItemLike)FrameRegistry.STICKER_FRAME_ITEM.get()).requires((ItemLike)Items.GLOW_INK_SAC).unlockedBy("has_sticker_frame", this.has((ItemLike)FrameRegistry.STICKER_FRAME_ITEM.get())).unlockedBy("has_glow_ink_sac", this.has((ItemLike)Items.GLOW_INK_SAC)).save(this.output);
            this.shaped(RecipeCategory.DECORATIONS, (ItemLike)FrameRegistry.GUI_STICKER_FRAME_ITEM.get()).pattern("XXX").pattern("XFX").pattern("XXX").define(Character.valueOf('X'), Ingredient.of(this.tagSet((TagKey<Item>)Tags.Items.RODS_WOODEN))).define(Character.valueOf('F'), (ItemLike)Items.ITEM_FRAME).unlockedBy("has_item_frame", this.has((ItemLike)Items.ITEM_FRAME)).save(this.output);
            this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)FrameRegistry.GLOW_GUI_STICKER_FRAME_ITEM.get()).requires((ItemLike)FrameRegistry.GUI_STICKER_FRAME_ITEM.get()).requires((ItemLike)Items.GLOW_INK_SAC).unlockedBy("has_gui_sticker_frame", this.has((ItemLike)FrameRegistry.GUI_STICKER_FRAME_ITEM.get())).unlockedBy("has_glow_ink_sac", this.has((ItemLike)Items.GLOW_INK_SAC)).save(this.output);
        }

        private HolderSet<Item> tagSet(TagKey<Item> tagKey) {
            return this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tagKey);
        }

        public static class Runner
        extends RecipeProvider.Runner {
            public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
                super(output, completableFuture);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
                return new StickerRecipes(provider, recipeOutput);
            }

            public String getName() {
                return "StickerFrames Recipes";
            }
        }
    }

    private static class StickerEnchantmentTags
    extends EnchantmentTagsProvider {
        public StickerEnchantmentTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "stickerframes");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(EnchantmentTags.NON_TREASURE).addOptional(FrameEnchantments.FOILED);
        }
    }

    private static class StickerDatapack
    extends DatapackBuiltinEntriesProvider {
        public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.ENCHANTMENT, FrameEnchantments::bootstrap);

        public StickerDatapack(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
            super(output, registries, BUILDER, modIds);
        }
    }

    private static class StickerLanguage
    extends LanguageProvider {
        public StickerLanguage(PackOutput packOutput) {
            super(packOutput, "stickerframes", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.stickerframes", "Sticker Frames");
            this.addItem((Supplier)FrameRegistry.STICKER_FRAME_ITEM, "Sticker Frame");
            this.addEntityType(FrameRegistry.STICKER_FRAME, "Sticker Frame");
            this.addItem((Supplier)FrameRegistry.GLOW_STICKER_FRAME_ITEM, "Glow Sticker Frame");
            this.addEntityType(FrameRegistry.GLOW_STICKER_FRAME, "Glow Sticker Frame");
            this.addItem((Supplier)FrameRegistry.GUI_STICKER_FRAME_ITEM, "GUI Sticker Frame");
            this.addEntityType(FrameRegistry.GUI_STICKER_FRAME, "GUI Sticker Frame");
            this.addItem((Supplier)FrameRegistry.GLOW_GUI_STICKER_FRAME_ITEM, "Glow GUI Sticker Frame");
            this.addEntityType(FrameRegistry.GLOW_GUI_STICKER_FRAME, "Glow GUI Sticker Frame");
            this.addEnchantment(FrameEnchantments.FOILED, "Foiled");
            this.addEnchantmentDescription(FrameEnchantments.FOILED, "Just enables the enchantment glint");
        }

        private void addEnchantment(ResourceKey<Enchantment> key, String name) {
            ResourceLocation location = key.location();
            this.add("enchantment." + location.getNamespace() + "." + location.getPath(), name);
        }

        private void addEnchantmentDescription(ResourceKey<Enchantment> key, String description) {
            ResourceLocation location = key.location();
            this.add("enchantment." + location.getNamespace() + "." + location.getPath() + ".desc", description);
        }
    }

    private static class StickerModels
    extends ModelProvider {
        public StickerModels(PackOutput packOutput) {
            super(packOutput, "stickerframes");
        }

        protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
            FrameRegistry.ITEMS.getEntries().forEach(item -> itemModels.generateFlatItem((Item)item.get(), ModelTemplates.FLAT_ITEM));
        }
    }
}

