/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.stickerframes.entity;

import com.mrbysco.stickerframes.registry.FrameRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class StickerFrame
extends ItemFrame
implements IEntityWithComplexSpawn {
    public StickerFrame(EntityType<? extends StickerFrame> entityType, Level level) {
        super(entityType, level);
    }

    public StickerFrame(Level level, BlockPos pos, Direction facingDirection) {
        super(FrameRegistry.STICKER_FRAME.get(), level, pos, facingDirection);
    }

    public StickerFrame(EntityType<? extends StickerFrame> entityType, Level level, BlockPos pos, Direction facingDirection) {
        super(entityType, level, pos, facingDirection);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.getDirection().get3DDataValue());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setDirection(Direction.from3DDataValue((int)additionalData.readInt()));
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack((ItemLike)FrameRegistry.STICKER_FRAME_ITEM.get());
    }

    public boolean isGlowing() {
        return false;
    }

    public boolean usesGuiDisplay() {
        return false;
    }
}

