package com.mdlc.bettergamemodeswitcher;

import com.mojang.brigadier.tree.RootCommandNode;
import net.minecraft.class_1934;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_637;


public final class GameModeConfiguration {
    private GameModeConfiguration() {
    }

    /**
     * Tests whether the {@code gamemode} command is available.
     */
    public static boolean hasPermission(class_310 minecraft) {
        class_634 connection = minecraft.method_1562();
        if (connection == null) {
            return true;
        }
        RootCommandNode<class_637> root = connection.method_2886().getRoot();
        return root.getChild("gamemode") != null;
    }

    /**
     * The player's last (or current) non-Spectator game mode.
     */
    private static class_1934 primaryGameMode = class_1934.field_9220;
    /**
     * The player's second-to-last non-Spectator game mode.
     */
    private static class_1934 secondaryGameMode = class_1934.field_9215;

    /**
     * Updates the primary and secondary game modes.
     */
    public static void handleGameModeChange(class_1934 gameMode) {
        if (gameMode != null && gameMode != class_1934.field_9219 && gameMode != primaryGameMode) {
            secondaryGameMode = primaryGameMode;
            primaryGameMode = gameMode;
        }
    }

    /**
     * Updates the primary and secondary game modes, taking into account the previous game mode.
     */
    public static void handleGameModeChange(class_1934 gameMode, class_1934 previousGameMode) {
        handleGameModeChange(previousGameMode);
        handleGameModeChange(gameMode);
    }

    /**
     * Returns the game mode that should be preselected given the current game mode.
     */
    public static class_1934 getSwitcherDefaultSelection(class_636 currentGameMode) {
        if (currentGameMode != null && currentGameMode.method_2920() == primaryGameMode) {
            return secondaryGameMode;
        } else {
            return primaryGameMode;
        }
    }
}
